import re
import json
from loguru import logger
def calculate_iou(inner_box, outer_box):
    # 提取内部边界框的四个顶点
    x1, y1 = inner_box[0]
    x2, y2 = inner_box[1]
    x3, y3 = inner_box[2]
    x4, y4 = inner_box[3]

    # 计算内部边界框的最小和最大坐标
    x_min_inner = min(x1, x2, x3, x4)
    y_min_inner = min(y1, y2, y3, y4)
    x_max_inner = max(x1, x2, x3, x4)
    y_max_inner = max(y1, y2, y3, y4)

    # 提取外部边界框的坐标
    x_min_outer, y_min_outer, x_max_outer, y_max_outer = outer_box

    # 计算交集的坐标
    x_min_inter = max(x_min_inner, x_min_outer)
    y_min_inter = max(y_min_inner, y_min_outer)
    x_max_inter = min(x_max_inner, x_max_outer)
    y_max_inter = min(y_max_inner, y_max_outer)

    # 计算交集的宽度和高度
    inter_width = max(0, x_max_inter - x_min_inter)
    inter_height = max(0, y_max_inter - y_min_inter)

    # 计算交集面积
    inter_area = inter_width * inter_height

    # 计算两个边界框的面积
    inner_area = (x_max_inner - x_min_inner) * (y_max_inner - y_min_inner)
    outer_area = (x_max_outer - x_min_outer) * (y_max_outer - y_min_outer)

    # 计算并集面积
    union_area = inner_area + outer_area - inter_area

    # 计算IoU
    iou = inter_area / union_area if union_area != 0 else 0

    return iou



def has_intersection(inner_box, outer_box, threshold=0.1):
    """
    判断inner_box是否与outer_box有交集（IOU > 0.1）。

    参数:
    inner_box (list): 内部边界框，格式为[[x1, y1], [x2, y2], [x3, y3], [x4, y4]]
    outer_box (list): 外部边界框，格式为[x_min, y_min, x_max, y_max]
    threshold (float): 判断交集的IOU阈值，默认为0.1

    返回:
    bool: 如果inner_box与outer_box有交集（IOU > threshold）则返回True，否则返回False。
    """
    iou = calculate_iou(inner_box, outer_box)
    return iou > 0

# def perform_re_check(text):
#     """
#     检查文本中是否包含公式。

#     参数:
#     text (str): 要检查的文本

#     返回:
#     bool: 如果包含公式则返回True，否则返回False。
#     """
#     formula_pattern = re.compile(
#         r"([A-Za-z]+\s*=\s*[A-Za-z0-9+\-*/^()]+)|"  # 一般公式，包含多个运算符或字母
#         r"(\b√[A-Za-z0-9]+\b)|"                     # 根号
#         r"(\bΔ\b)|"                                 # Δ
#         r"(\([A-Za-z0-9+\-*/^()]+\)\s*[+\-*/^]\s*\([A-Za-z0-9+\-*/^()]+\))|"  # 复杂括号表达式
#         r"([A-Za-z]*\d*[(x)(y)(z)(a)(b)(c)]*\s*[+\-*/^]+\s*\(?[A-Za-z0-9+\-*/^()]+\)?)"  # 公式中的符号运算
#     )
#     return bool(formula_pattern.search(text))
def perform_re_check(text):
    # 规则1：过滤掉包含仅字母、空格或中文字符的文本
    if re.fullmatch(r'[\u4e00-\u9fa5a-zA-Z\s]+', text):
        return False
    
    # 规则2：过滤掉不带“=”符号的text
    if '=' not in text:
        return False
    
    # 规则3：过滤掉表达式和赋值，例如a=5
    if re.fullmatch(r'[a-zA-Z]+\s*=\s*\d+', text):
        return False
    
    return True

def filter_boxes(ocr_result, layout_result):
    """
    过滤排版检测结果，保留下包含公式的边界框。

    参数:
    ocr_result (dict): OCR识别结果
    layout_result (dict): 布局检测结果

    返回:
    list: 过滤后的排版检测结果
    """
    logger.info('in filter_boxes!')
    #layout_data = json.loads(json.loads(layout_result['data'])['Ids_Scores_boxes'])
    layout_data=layout_result
    filtered_layout_boxes = []
    filtered_layout_ocrs=[]
    for layout_box in layout_data:
        layout_coordinates = layout_box[2]
        combined_text = ""
        for ocr_box in ocr_result['data']:
            ocr_coordinates = ocr_box[0]
            ocr_text = ocr_box[1][0]
            if has_intersection(ocr_coordinates, layout_coordinates):
                combined_text += ocr_text + " "
        
        if perform_re_check(combined_text.strip()):
            filtered_layout_boxes.append(layout_box)
            filtered_layout_ocrs.append(combined_text)
    
    return filtered_layout_boxes,filtered_layout_ocrs

# # 示例使用
# ocr_result = {'errorCode': 0, 'msg': '识别成功', 'data': [[[[96.0, 44.0], [569.0, 44.0], [569.0, 64.0], [96.0, 64.0]], ['1.4.1用空间向量研究直线、平面的位置关系（第3课时）', 0.9963806867599487]], [[[238.0, 97.0], [426.0, 97.0], [426.0, 116.0], [238.0, 116.0]], ['空间中直线、平面的垂直', 0.9977184534072876]], [[[73.0, 145.0], [180.0, 145.0], [180.0, 170.0], [73.0, 170.0]], ['知识清单', 0.998611330986023]], [[[105.0, 187.0], [231.0, 187.0], [231.0, 204.0], [105.0, 204.0]], ['1.直线和直线垂直', 0.9975678324699402]], [[[103.0, 213.0], [544.0, 214.0], [544.0, 234.0], [103.0, 233.0]], ['设直线,l的方向向量分别为u,μ,则uuuu=3.', 0.8799490332603455]], [[[104.0, 243.0], [231.0, 243.0], [231.0, 260.0], [104.0, 260.0]], ['2.直线和平面垂直', 0.9996089935302734]], [[[105.0, 269.0], [591.0, 269.0], [591.0, 286.0], [105.0, 286.0]], ['设u是直线l的方向向量，n是平面α的法向量，lα,则lLαu/nA', 0.8951645493507385]], [[[71.0, 296.0], [177.0, 298.0], [177.0, 316.0], [71.0, 314.0]], ['eR,使得ux入n.', 0.871402382850647]], [[[105.0, 325.0], [267.0, 325.0], [267.0, 341.0], [105.0, 341.0]], ['要点3平面和平面垂直', 0.9992749094963074]], [[[103.0, 349.0], [530.0, 351.0], [530.0, 371.0], [103.0, 369.0]], ['设n,n分别是平面α,β的法向量，则α⊥βn,⊥nn*n=1.', 0.8930713534355164]], [[[73.0, 397.0], [179.0, 397.0], [179.0, 421.0], [73.0, 421.0]], ['例题讲评', 0.9989429712295532]], [[[113.0, 441.0], [592.0, 441.0], [592.0, 461.0], [113.0, 461.0]], ['例1如图,已知正三棱柱ABC-A,B,C,的各棱长都为1,M是底面上', 0.9656786918640137]], [[[72.0, 474.0], [309.0, 474.0], [309.0, 490.0], [72.0, 490.0]], ['BC边的中点，V是侧棱CC上的点，', 0.991436243057251]], [[[102.0, 508.0], [162.0, 504.0], [163.0, 525.0], [104.0, 528.0]], ['且CV=', 0.9438493251800537]], [[[175.0, 507.0], [203.0, 510.0], [201.0, 526.0], [174.0, 524.0]], ['CC,', 0.7943589091300964]], [[[161.0, 522.0], [174.0, 522.0], [174.0, 531.0], [161.0, 531.0]], ['4', 0.9967143535614014]], [[[104.0, 544.0], [234.0, 544.0], [234.0, 560.0], [104.0, 560.0]], ['（1)求证：ABLMN;', 0.8688576817512512]], [[[103.0, 568.0], [343.0, 569.0], [343.0, 589.0], [103.0, 588.0]], ['(2)设CC,中点为D,求证：AB,⊥A,D.', 0.8998482823371887]], [[[106.0, 736.0], [589.0, 738.0], [589.0, 758.0], [106.0, 756.0]], ['练习1如图，△ABC和△BCD所在平面互相垂直，且AB=BC=BD=', 0.9863734245300293]], [[[72.0, 773.0], [519.0, 773.0], [519.0, 789.0], [72.0, 789.0]], ['2,ZABC=ZDBC=120°，E，F分别为AC，DC的中点.求证：EF⊥BC.', 0.9168810844421387]]]}
# layout_result = {'errorCode': 0, 'msg': '识别成功', 'data': '{"Ids_Scores_boxes": "[[[0], 0.5164221525192261, [72.51856621809566, 187.46995484912938, 593.7710048745755, 369.08707769273684]], [[10], 0.4314861297607422, [74.0, 741.0, 589.0, 788.0]], [[1], 0.8855363726615906, [74.0858920888629, 143.8997421042558, 179.57114012112666, 169.70436416413207]], [[1], 0.8849098086357117, [73.6531480480851, 396.0868356459496, 178.90487691988264, 420.96475408517415]], [[1], 0.8246437907218933, [94.7679979762152, 44.78538083893527, 567.6477659821933, 64.29004998079591]], [[1], 0.0, [241.0, 100.0, 425.0, 114.0]], [[0], 0.0, [74.0, 443.0, 592.0, 587.0]]]", "boxes_num": "7"}'}

# filtered_layout_boxes = filter_boxes(ocr_result, layout_result)
# print(filtered_layout_boxes)
