import requests
import time

def ocr_service_request(image_url):
    """
    向指定的 OCR 服务发送请求，并返回响应信息。

    参数:
    - image_url: 图像的 URL 路径

    返回:
    - response_json: 成功时返回的响应内容（JSON 格式）
    - elapsed_time: 请求和响应之间的时间（秒）
    - status_code: 请求的 HTTP 状态码
    - error_message: 请求失败时的错误消息
    """
    
    # 请求数据
    data_info = {
        "url": image_url,
    }
    
    try:
        # 记录请求开始的时间
        start_time = time.time()
        
        # 发送 POST 请求
        response = requests.post('http://localhost:8880/v1/got_ocr_markdown_local', json=data_info)
        
        # 记录请求结束的时间
        end_time = time.time()
        
        # 计算请求和响应之间的时间
        elapsed_time = end_time - start_time
        
        # 返回请求相关信息
        if response.status_code == 200:
            return response.json(), elapsed_time, response.status_code, None
        else:
            return None, elapsed_time, response.status_code, response.text
    
    except requests.exceptions.RequestException as e:
        return None, None, None, str(e)

# 调用示例
if __name__ == "__main__":
    image_url = '/data/wangtengbo/got_ocr2/infer/demo.png'  # 替换为需要处理的图片路径
    response_json, elapsed_time, status_code, error_message = ocr_service_request(image_url)
    
    if status_code == 200:
        print(f"Request successful! Time taken: {elapsed_time:.2f} seconds")
        print("Response content:", response_json)
    else:
        print(f"Request failed with status code {status_code}. Error: {error_message}")
