import re

def find_and_highlight_substring(A, B):
    # 正则表达式匹配B
    pattern = re.escape(B)
    
    # 存储匹配到的内容的起始和结束下标
    matches = []

    # 处理单个$符号内的内容
    def single_dollar_replacement(match):
        start = match.start(1)
        end = match.end(1)
        inner_text = match.group(1)
        highlighted_text = re.sub(pattern, r'<span style="color:red">\g<0></span>', inner_text)
        matches.append((start, end))
        return f"${highlighted_text}$"

    # 处理双个$$符号内的内容
    def double_dollar_replacement(match):
        start = match.start(1)
        end = match.end(1)
        inner_text = match.group(1)
        highlighted_text = re.sub(pattern, r'<span style="color:red">\g<0></span>', inner_text)
        matches.append((start, end))
        return f"$${highlighted_text}$$"

    # 使用正则表达式替换并标记匹配位置
    highlighted_A = re.sub(r'\$(.*?)\$', single_dollar_replacement, A)
    highlighted_A = re.sub(r'\$\$(.*?)\$\$', double_dollar_replacement, highlighted_A)

    return highlighted_A, matches

# # 示例
# A = '# 1.4.1 用空间向量研究直线、平面的位置关系（第3课时）\n\n## 空间中直线、平面的垂直\n\n### 知识清单\n\n1. 直线和直线垂直\n设直线 $l_1, l_2$ 的方向向量分别为 $$u_1, u_2$$，则 $$l_1 \perp l_2 \Leftrightarrow u_1 \cdot u_2 = 0$$。'
# B = 'l_1 \perp l_2'

# highlighted_A, matches = find_and_highlight_substring(A, B)
# print("Highlighted A:\n", highlighted_A)
# print("Matches:", matches)
