import matplotlib.pyplot as plt
import matplotlib as mpl

# 设置 LaTeX 渲染
mpl.rcParams['text.usetex'] = True
mpl.rcParams['font.size'] = 12

# LaTeX 公式
latex_formula = r'$a \perp b \Leftrightarrow a \cdot b = 0$'

# 创建一个图形和轴
fig, ax = plt.subplots()

# 隐藏轴
ax.axis('off')

# 显示 LaTeX 公式
ax.text(0.5, 0.5, latex_formula, fontsize=20, ha='center', va='center')

# 保存图形为图像
output_image_path = "latex_formula.png"
plt.savefig(output_image_path, bbox_inches='tight')

# 显示图像
plt.show()
