import os
from openai import OpenAI
from loguru import logger
from config.config import QWEN_API_KEY,QWEN_URL,QWEN_MODEL

def qwen_vl_infer(
    image_url: str,
    system_prompt:str,
    user_prompt:str
) -> str:
    """
    使用指定的多模态模型，对给定图片 URL 进行描述。
    
    Args:
        api_key (str): OpenAI API 密钥。
        image_url (str): 要描述的图片地址。
        model (str): 模型名称，默认为 qwen-vl-max-latest。
        base_url (str): 接口基础 URL。
    
    Returns:
        str: 模型返回的描述文本；出错时返回空字符串。
    """
    try:
        client = OpenAI(
            api_key=QWEN_API_KEY,
            base_url=QWEN_URL,
        )

        messages = [
            {
                "role": "system",
                "content": [{"type": "text", "text": system_prompt}],
            },
            {
                "role": "user",
                "content": [
                    {"type": "image_url", "image_url": {"url": image_url}},
                    {"type": "text", "text": user_prompt},
                ],
            },
        ]

        completion = client.chat.completions.create(
            model=QWEN_MODEL,
            messages=messages,
        )

        description = completion.choices[0].message.content
        logger.info("Received description from model")
        return description

    except Exception as e:
        logger.error(f"Unexpected Qwen Infer error: {e},completion={completion}", exc_info=True)

    return ""