# import re

# def normalize_latex_string(s: str) -> str:
#     # 1. 去除所有空格和常见的LaTeX空白指令
#     s = s.replace(" ", "")
#     s = re.sub(r'\\[ ,;!]', '', s)  # 移除 \, \; \! 等空白控制命令

#     # 2. 标准化上下标形式
#     # 将 ^{...} -> ^... 以及类似的下标
#     # 如遇到更复杂的内容可根据实际情况调整
#     s = re.sub(r'\^\{\s*(.*?)\s*\}', r'^\1', s)
#     s = re.sub(r'\_\{\s*(.*?)\s*\}', r'_\1', s)

#     # 对于简单的单字符上标下标，如 I ^ 2，若存在空格已去除，不需要额外处理
#     # 如果还存在多余花括号，现在统一处理多余的花括号
#     s = s.replace("{", "").replace("}", "")

#     # 3. 处理特殊算子、函数
#     # \cdot、\times 用 * 表示
#     s = s.replace(r'\cdot', '*')
#     s = s.replace(r'\times', '*')

#     # 4. 处理分数 \frac{a}{b} -> (a/b)
#     s = re.sub(r'\\frac\s*\((.*?)\)\s*\((.*?)\)', r'(\1/\2)', s) # 若已无花括号，可用此
#     # 如果原式有花括号分隔，例如 \frac{a}{b}:
#     s = re.sub(r'\\frac\s*(\S+)\s*(\S+)', r'(\1/\2)', s)
#     # 若 \frac{a}{b} 中 a,b 本来就是用 {} 包围，可在上面统一处理后再替换
#     # 上面已去除花括号，所以可以匹配更简单

#     # 由于上面对frac的匹配可能需要更严谨的处理，可考虑：
#     # 利用一种更强的regex匹配 \frac{a}{b}，其中a,b为一组字符
#     # 先恢复一部分逻辑（若frac的参数在花括号中）
#     s = re.sub(r'\\frac\s*\((.*?)\)\s*\((.*?)\)', r'(\1/\2)', s)
#     s = re.sub(r'\\frac(\w+)(\w+)', r'(\1/\2)', s)

#     # 再尝试匹配剩余可能的 \frac{...}{...} 模式：
#     s = re.sub(r'\\frac(\S+)\(\S+/\S+\)', lambda m: '(' + m.group(1)[1:-1] + '/' + m.group(2)[1:-1] + ')', s)
#     # 由于各种复杂情况，这里已较复杂，实际使用请根据具体格式定制化。

#     # 简化思路：匹配 \frac{...}{...}
#     s = re.sub(r'\\frac\s*\(?([^\(\)]+)\)?\s*\(?([^\(\)]+)\)?', r'(\1/\2)', s)

#     # 5. \sqrt{x} -> sqrt(x)
#     s = re.sub(r'\\sqrt\s*(\S+)', r'sqrt(\1)', s)

#     # 6. 去除 \left \right 这类大小调整命令
#     s = s.replace(r'\left', '')
#     s = s.replace(r'\right', '')

#     # 7. 移除非必要的命令，如 \mathrm, \mathbf, \text, \displaystyle 等
#     s = re.sub(r'\\mathrm|\\mathbf|\\text|\\displaystyle|\\normalfont|\\rm', '', s)

#     # 8. 去除残余的反斜杠和空括号（如有）
#     # 若无特定命令剩下的裸 \ 符号不常见，直接删除
#     s = s.replace("\\", "")

#     #再次清除多余空格（万一有）
#     s = s.strip()

#     return s

# def latex_match(A: str, B: str) -> bool:
#     A_norm = normalize_latex_string(A)
#     B_norm = normalize_latex_string(B)
#     return A_norm in B_norm

def cal_details_path(text,info_dict):
    for path_key,sub_details in info_dict.items():
        if text == sub_details:
            return path_key
    return None
        
# if __name__=="__main__":
#     # t=[{'type': 'paragraph', 'tags': [], 'paragraph_id': 0, 'page_id': 1, 'content': 0, 'position': [212, 51, 1987, 51, 1987, 120, 212, 120], 'outline_level': 1, 'text': 'GAOZHONG WULI GONGSHI DINGLI DINGLU TUBIAO'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 1, 'page_id': 1, 'content': 0, 'position': [74, 143, 1240, 143, 1240, 241, 74, 241], 'outline_level': -1, 'text': '高中物理公式、定理、定律图表'}, {'paragraph_id': 2, 'page_id': 1, 'content': 0, 'outline_level': -1, 'text': ' ', 'type': 'image', 'position': [51, 241, 206, 235, 212, 379, 57, 384], 'image_url': 'https://web-api.textin.com/ocr_image/external/88392321f41f4542.jpg', 'sub_type': 'image'}, {'paragraph_id': 3, 'page_id': 1, 'content': 0, 'outline_level': -1, 'text': '四、焦耳定律 ', 'type': 'image', 'position': [1286, 379, 2429, 373, 2440, 1177, 1292, 1177], 'image_url': 'https://web-api.textin.com/ocr_image/external/49492c33f0ca4aaf.jpg', 'sub_type': 'image'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 4, 'page_id': 1, 'content': 0, 'position': [287, 1275, 890, 1275, 890, 1378, 287, 1378], 'outline_level': 1, 'text': '一、知识图解'}, {'paragraph_id': 5, 'page_id': 1, 'content': 0, 'outline_level': -1, 'text': '电功： W=qU=UI 、电功率： P=IU 电功与电热 焦耳定律： Q = I ^ { 2 } R 、 热功率： P _ { 热 } = I ^ { 2 } R ', 'type': 'image', 'position': [890, 1470, 2934, 1447, 2934, 1860, 890, 1883], 'image_url': 'https://web-api.textin.com/ocr_image/external/81951d40a79f0c89.jpg', 'sub_type': 'image'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 6, 'page_id': 1, 'content': 0, 'position': [292, 1906, 1085, 1906, 1085, 2010, 292, 2010], 'outline_level': 1, 'text': '二、重要知识剖析'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 7, 'page_id': 1, 'content': 0, 'position': [246, 2113, 827, 2113, 827, 2193, 246, 2193], 'outline_level': -1, 'text': '区分电功和电热'}]
#     # info_dict={'/data/wangtengbo/Deployments_Formula_Checker_v5_复现并微调_v7.0-合和OCR-没有版面/app/logs_data/sub_images/20241210152612700/formula_1.png': [{'type': 'paragraph', 'tags': [], 'paragraph_id': 0, 'page_id': 1, 'content': 0, 'position': [212, 51, 1987, 51, 1987, 120, 212, 120], 'outline_level': 1, 'text': 'GAOZHONG WULI GONGSHI DINGLI DINGLU TUBIAO'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 1, 'page_id': 1, 'content': 0, 'position': [74, 143, 1240, 143, 1240, 241, 74, 241], 'outline_level': -1, 'text': '高中物理公式、定理、定律图表'}, {'paragraph_id': 2, 'page_id': 1, 'content': 0, 'outline_level': -1, 'text': ' ', 'type': 'image', 'position': [51, 241, 206, 235, 212, 379, 57, 384], 'image_url': 'https://web-api.textin.com/ocr_image/external/88392321f41f4542.jpg', 'sub_type': 'image'}, {'paragraph_id': 3, 'page_id': 1, 'content': 0, 'outline_level': -1, 'text': '四、焦耳定律 ', 'type': 'image', 'position': [1286, 379, 2429, 373, 2440, 1177, 1292, 1177], 'image_url': 'https://web-api.textin.com/ocr_image/external/49492c33f0ca4aaf.jpg', 'sub_type': 'image'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 4, 'page_id': 1, 'content': 0, 'position': [287, 1275, 890, 1275, 890, 1378, 287, 1378], 'outline_level': 1, 'text': '一、知识图解'}, {'paragraph_id': 5, 'page_id': 1, 'content': 0, 'outline_level': -1, 'text': '电功： W=qU=UI 、电功率： P=IU 电功与电热 焦耳定律： Q = I ^ { 2 } R 、 热功率： P _ { 热 } = I ^ { 2 } R ', 'type': 'image', 'position': [890, 1470, 2934, 1447, 2934, 1860, 890, 1883], 'image_url': 'https://web-api.textin.com/ocr_image/external/81951d40a79f0c89.jpg', 'sub_type': 'image'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 6, 'page_id': 1, 'content': 0, 'position': [292, 1906, 1085, 1906, 1085, 2010, 292, 2010], 'outline_level': 1, 'text': '二、重要知识剖析'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 7, 'page_id': 1, 'content': 0, 'position': [246, 2113, 827, 2113, 827, 2193, 246, 2193], 'outline_level': -1, 'text': '区分电功和电热'}], '/data/wangtengbo/Deployments_Formula_Checker_v5_复现并微调_v7.0-合和OCR-没有版面/app/logs_data/sub_images/20241210152612700/formula_2.png': [{'type': 'paragraph', 'tags': [], 'paragraph_id': 0, 'page_id': 1, 'content': 0, 'position': [712, 7, 726, 7, 726, 0, 719, 7], 'outline_level': -1, 'text': '-'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 1, 'page_id': 1, 'content': 0, 'position': [430, 0, 712, 0, 712, 14, 430, 14], 'outline_level': -1, 'text': '---- -'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 3, 'page_id': 1, 'content': 0, 'position': [529, 7, 529, 0, 529, 14, 536, 14], 'outline_level': -1, 'text': '-'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 6, 'page_id': 1, 'content': 0, 'position': [183, 49, 3781, 49, 3781, 373, 183, 373], 'outline_level': -1, 'text': '电流做功的过程，就是把电能转化为其他形式能的过程.但有些电路元件，只将电能转化为内能，有些电路元件，电流做功将电能一部分转化为内能，还有一部分转化为其他形式的能，如机械能或化学能等.'}, {'type': 'paragraph', 'tags': ['formula'], 'paragraph_id': 7, 'page_id': 1, 'content': 0, 'position': [183, 409, 3774, 409, 3774, 754, 183, 754], 'outline_level': -1, 'text': '在纯电阻电路中：电能全部转化为内能，电功和电热相等，电功率和热功率相等.在非纯电阻电路中，电路消耗的电能W=UIt分为两部分，一大部分转化为其他形式的能；另一部分转化为内能.此时有W&gt;Q，故.此时电功只能用W=UIt计算，电热只能用$Q = I ^ { 2 } R t$计算.'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 8, 'page_id': 1, 'content': 0, 'position': [402, 846, 1192, 839, 1192, 945, 402, 952], 'outline_level': 1, 'text': '三、学习方法引导'}, {'type': 'paragraph', 'tags': ['formula', 'formula', 'formula'], 'paragraph_id': 9, 'page_id': 1, 'content': 0, 'position': [232, 1213, 994, 1213, 994, 2173, 232, 2173], 'outline_level': -1, 'text': '**名师经验谈：**①电动机是非纯电阻电路，要注意区分电功率和热功率，电功率用$P _ { 总 } = U I$ 计算，热功率$P _ { 热 } = P R$,机械功率$P _ { 机 } = P _ { 总 } - P$热·②注意搞清电动机电路中的能量转化关系.用能量守恒定律来分析问题.'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 10, 'page_id': 1, 'content': 0, 'position': [1319, 1135, 2744, 1135, 2744, 1220, 1319, 1220], 'outline_level': -1, 'text': '题型 区分纯电阻电路和非纯电阻电路'}, {'paragraph_id': 11, 'page_id': 1, 'content': 0, 'outline_level': -1, 'text': 'M A 电动机 ', 'type': 'image', 'position': [3139, 1206, 3774, 1206, 3774, 1658, 3139, 1658], 'image_url': 'https://web-api.textin.com/ocr_image/external/f72f9fe6ab6a37bb.jpg', 'sub_type': 'image'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 13, 'page_id': 1, 'content': 0, 'position': [1319, 1255, 3069, 1255, 3069, 1707, 1319, 1707], 'outline_level': -1, 'text': '**例题** 汽车电动机启动时车灯会瞬时变暗，如图所示，在打开车灯的情况下，电动机未启动时电流表读数为10A，电动机启动时电流表读数为58A、若电源电动势为12.5V，内阻'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 14, 'page_id': 1, 'content': 0, 'position': [1319, 1735, 3781, 1735, 3781, 1961, 1319, 1961], 'outline_level': -1, 'text': '为0.05Ω，电流表内阻不计，则因电动机启动，车灯的电功率降低了( )'}, {'type': 'paragraph', 'tags': [], 'paragraph_id': 15, 'page_id': 1, 'content': 0, 'position': [1319, 1982, 3690, 1982, 3690, 2067, 1319, 2067], 'outline_level': -1, 'text': 'A.35.8 W B.43.2 W C.48.2 W D.76.8 W'}, {'type': 'paragraph', 'tags': ['formula', 'formula', 'formula', 'formula', 'formula', 'formula', 'formula', 'formula', 'formula'], 'paragraph_id': 18, 'page_id': 1, 'content': 0, 'position': [1312, 2095, 3753, 2095, 3753, 3090, 1312, 3090], 'outline_level': -1, 'text': '**解析：**假设r为电源内阻，R 为车灯电阻，$I _ { 1 }$为未启动电动机时流过电流表的电流.在没启动电动机时，满足闭合电路的欧姆定律，$r + R _ { 火 }$ $k J = \\frac { E } { I _ { 1 } }$得： $R _ { 灯 } = \\frac { E } { I _ { 1 } } - r = 1 . 2 \\Omega$ 此时车灯功率为： $P _ { 灯 1 } = 1 2 0 W .$启动电动机后，流过电流表的电流$I _ { 2 } = 5 8$A，此时车灯两端电压为：$U _ { 灯 2 } = E - I _ { 2 } r = 9 . 6 V$，此时车灯功率为$P _ { 灯 2 } = \\frac { U ^ { 2 } k J 2 } { R _ { 灯 } } = \\frac { 9 . 6 ^ { 2 } } { 1 . 2 } W = 7 6 . 8 W .$电动机启动后车灯功率减少了$\\Delta P = P _ { 灯 1 } - P _ { 灯 2 } = 4 3 . 2$W 答案 **B**'}, {'paragraph_id': 19, 'page_id': 1, 'tags': [], 'outline_level': -1, 'text': '66', 'type': 'paragraph', 'position': [84, 3443, 190, 3443, 190, 3527, 84, 3527], 'content': 1, 'sub_type': 'footer'}]}
#     # print(cal_details_path(t,info_dict))

#     text_A="""$\\frac { \\sqrt { a } } { \\sqrt { b } } = \\sqrt { \\frac { a } { b } } ( a > 0 )$·"""
#     text_B=r"\frac { \sqrt { a } } { \sqrt { b } } = \sqrt { \frac { a } { b } } ( a > 0 )"
#     print(latex_match(text_B,text_A)) #False

import re

def normalize_latex_string(s: str) -> str:
    # 1. 去除空格和数学环境符号
    s = s.replace(" ", "").replace("$", "")
    s = re.sub(r'\\[ ,;!]', '', s)  # 移除 \, \; \! 等

    # 2. 处理上标和下标
    s = re.sub(r'\^\{\s*(.*?)\s*\}', r'^\1', s)
    s = re.sub(r'\_\{\s*(.*?)\s*\}', r'_\1', s)
    s = s.replace("{", "").replace("}", "")  # 去除剩余花括号

    # 3. 替换算子和特殊符号
    s = s.replace(r'\cdot', '*').replace(r'\times', '*')

    # 4. 处理分数
    s = re.sub(r'\\frac\s*\{([^{}]+)\}\s*\{([^{}]+)\}', r'(\1/\2)', s)

    # 5. 处理平方根
    s = re.sub(r'\\sqrt\s*\{([^{}]+)\}', r'sqrt(\1)', s)

    # 6. 移除 \left 和 \right
    s = s.replace(r'\left', '').replace(r'\right', '')

    # 7. 移除格式化命令
    s = re.sub(r'\\mathrm|\\mathbf|\\text|\\displaystyle|\\normalfont|\\rm', '', s)

    # 8. 移除残余反斜杠
    s = s.replace("\\", "")

    # 去除多余空格
    return s.strip()

def latex_match(A: str, B: str) -> bool:
    A_norm = normalize_latex_string(A)
    B_norm = normalize_latex_string(B)
    #print("Normalized A:", A_norm)
    #print("Normalized B:", B_norm)
    return A_norm in B_norm

if __name__ == "__main__":
    text_B = r"\frac { \sqrt { 8 } } { \sqrt { 2 a } } = \frac { \sqrt { 8 } \cdot \sqrt { 2 a } } { \sqrt { 2 a } \cdot \sqrt { 2 a } } = \frac { 4 \sqrt { a } } { 2 a } = \frac { 2 \sqrt { a } } { a }"
    text_A = r"'(3)$\\frac { \\sqrt { 8 } } { \\sqrt { 2 a } } = \\frac { \\sqrt { 8 } \\cdot \\sqrt { 2 a } } { \\sqrt { 2 a } \\cdot \\sqrt { 2 a } } = \\frac { 4 \\sqrt { a } } { 2 a } = \\frac { 2 \\sqrt { a } } { a } .$"
    print(latex_match(text_B, text_A))  # 应该返回 True
