import re

# 标准化策略1：基础标准化
def normalize_strategy_1(s: str) -> str:
    s = s.replace(" ", "").replace("$", "")
    s = re.sub(r'\\[ ,;!]', '', s)  # 移除 \, \; \! 等
    s = re.sub(r'\^\{\s*(.*?)\s*\}', r'^\1', s)
    s = re.sub(r'\_\{\s*(.*?)\s*\}', r'_\1', s)
    s = s.replace("{", "").replace("}", "")
    s = s.replace(r'\cdot', '*').replace(r'\times', '*')
    s = re.sub(r'\\frac\s*\{([^{}]+)\}\s*\{([^{}]+)\}', r'(\1/\2)', s)
    s = re.sub(r'\\sqrt\s*\{([^{}]+)\}', r'sqrt(\1)', s)
    s = s.replace(r'\left', '').replace(r'\right', '')
    s = re.sub(r'\\mathrm|\\mathbf|\\text|\\displaystyle|\\normalfont|\\rm', '', s)
    s = s.replace("\\", "")
    return s.strip()

# 标准化策略2：更宽松的标准化
def normalize_strategy_2(s: str) -> str:
    s = re.sub(r'\\[a-zA-Z]+', '', s)  # 去掉所有 LaTeX 命令
    s = re.sub(r'[^a-zA-Z0-9^_*/().]', '', s)  # 保留基本符号
    return s.strip()

# 标准化策略3：保留部分数学符号
def normalize_strategy_3(s: str) -> str:
    s = s.replace(" ", "").replace("$", "")
    s = re.sub(r'\\frac\s*\{([^{}]+)\}\s*\{([^{}]+)\}', r'(\1/\2)', s)
    s = re.sub(r'\\sqrt\s*\{([^{}]+)\}', r'sqrt(\1)', s)
    s = s.replace("\\", "")
    return s.strip()

# 标准化策略4：完全删除所有 LaTeX 特殊符号，仅保留文字和数字
def normalize_strategy_4(s: str) -> str:
    s = re.sub(r'\\[a-zA-Z]+', '', s)  # 去掉所有 LaTeX 命令
    s = re.sub(r'[{}^_\\]', '', s)  # 去掉特殊符号
    s = s.replace(" ", "").replace("$", "")
    return s.strip()

# 主函数
def normalize_latex_string(s: str, strategy: int) -> str:
    if strategy == 1:
        return normalize_strategy_1(s)
    elif strategy == 2:
        return normalize_strategy_2(s)
    elif strategy == 3:
        return normalize_strategy_3(s)
    elif strategy == 4:
        return normalize_strategy_4(s)
    else:
        raise ValueError("Invalid normalization strategy")

# 匹配函数
def latex_match(A: str, B: str) -> bool:
    for strategy in range(1, 5):  # 尝试所有标准化策略
        A_norm = normalize_latex_string(A, strategy)
        B_norm = normalize_latex_string(B, strategy)
        if A_norm in B_norm:
            return True
    return False

# 测试代码
if __name__ == "__main__":
    text_B = r"\frac { \sqrt { 8 } } { \sqrt { 2 a } } = \frac { \sqrt { 8 } \cdot \sqrt { 2 a } } { \sqrt { 2 a } \cdot \sqrt { 2 a } } = \frac { 4 \sqrt { a } } { 2 a } = \frac { 2 \sqrt { a } } { a }"
    text_A = r"'(3)$\\frac { \\sqrt { 8 } } { \\sqrt { 2 a } } = \\frac { \\sqrt { 8 } \\cdot \\sqrt { 2 a } } { \\sqrt { 2 a } \\cdot \\sqrt { 2 a } } = \\frac { 4 \\sqrt { a } } { 2 a } = \\frac { 2 \\sqrt { a } } { a } .$"
    print(latex_match(text_B, text_A))  # 应该返回 True
