import os
from datetime import datetime
import langid
import json
import base64
import re
def save_logs_to_file(logs_info, file_name=None):
    if file_name==None:
        return False
    with open(file_name, 'w', encoding='utf-8') as file:
        json.dump(logs_info, file, ensure_ascii=False, indent=4)
    return True
def clean_markdown(markdown_text):
    """
    清理Markdown文本，移除所有图像链接、HTML注释及其他无用信息，仅保留正文内容。
    
    参数：
    markdown_text (str): 输入的Markdown格式文本。
    
    返回：
    str: 清理后的正文内容。
    """
    # 删除HTML <img> 标签
    markdown_text = re.sub(r'<img[^>]*>', '', markdown_text)
    
    # 删除Markdown ![]() 语法的图片
    markdown_text = re.sub(r'!\[[^\]]*\]\([^)]*\)', '', markdown_text)
    
    # 删除HTML注释 <!-- ... -->
    markdown_text = re.sub(r'<!--.*?-->', '', markdown_text, flags=re.DOTALL)
    
    # # 删除多余的空行（可选）
    # markdown_text = re.sub(r'\n\s*\n', '\n\n', markdown_text)
    
    # 去除行尾多余的空白字符
    markdown_text = re.sub(r'[ \t]+$', '', markdown_text, flags=re.MULTILINE)
    
    return markdown_text.strip()



import re

def contains_formula(markdown_info):
    """
    全面覆盖公式模式的函数：判断 Markdown 文本中是否包含公式。
    
    参数:
        markdown_info (str): Markdown 文本。
        
    返回:
        bool: 如果包含公式返回 True，否则返回 False。
    """
    # 全面公式检测正则模式
    formula_patterns = [
        r'\$.*?\$',                      # 行内公式，例如 $a = b + c$
        r'\$\$.*?\$\$',                  # 块级公式，例如 $$a = b + c$$
        r'\\\(.+?\\\)',                  # 行内公式，例如 \(a = b + c\)
        r'\\\[.+?\\\]',                  # 块级公式，例如 \[a = b + c\]
        r'\\frac\s*{.*?}\s*{.*?}',       # LaTeX 分式，例如 \frac{a}{b}
        r'[a-zA-Z]\s*_\s*{.*?}',         # 下标公式，例如 a_{n}
        r'[a-zA-Z]\s*\^\s*{.*?}',        # 上标公式，例如 a^{2}
        r'[a-zA-Z]\s*=\s*.+',            # 常见赋值公式，例如 a = b + c
        r'\\int\s*.*',                   # 积分公式，例如 \int_{a}^{b} x^2 dx
        r'\\sum\s*.*',                   # 求和公式，例如 \sum_{i=1}^n i
        r'\\prod\s*.*',                  # 求积公式，例如 \prod_{i=1}^n i
        r'\\lim\s*.*',                   # 极限公式，例如 \lim_{x \to 0} f(x)
        r'\\sqrt\s*{.*?}',               # 平方根，例如 \sqrt{x}
        r'\\log\s*.*',                   # 对数公式，例如 \log_{2}x
        r'\\sin|\\cos|\\tan|\\arcsin|\\arccos|\\arctan',  # 三角函数
        r'\\left.*?\\right',             # 带括号的公式，例如 \left( x+y \right)
        r'\\mathrm\s*{.*?}',             # LaTeX 数学字体控制，例如 \mathrm{sin}
        r'\\overline\s*{.*?}',           # 上划线，例如 \overline{AB}
        r'\\underline\s*{.*?}',          # 下划线，例如 \underline{AB}
        r'\\cdot|\\times|\\div|\\pm',    # 运算符，例如 \cdot, \times, \div, \pm
        r'[a-zA-Z]\s*\\to\s*.*',         # 函数关系，例如 x \to y
        r'[Α-Ωα-ω]',                    # 希腊字母，例如 Φ, θ
        r'[a-zA-Z]+\s*=\s*[a-zA-Z0-9]+\s*(cos|sin|tan|log|exp|sqrt)\s*[a-zA-Z0-9θ]*',  # 带函数符号的公式
    ]
    
    # 组合所有正则进行检测
    for pattern in formula_patterns:
        if re.search(pattern, markdown_info, re.DOTALL):
            return True
    
    return False

# def contains_formula(markdown_info):
#     """
#     全面覆盖公式模式的函数：判断 Markdown 文本中是否包含公式。
    
#     参数:
#         markdown_info (str): Markdown 文本。
        
#     返回:
#         bool: 如果包含公式返回 True，否则返回 False。
#     """
#     # 全面公式检测正则模式
#     formula_patterns = [
#         r'\$.*?\$',                      # 行内公式，例如 $a = b + c$
#         r'\$\$.*?\$\$',                  # 块级公式，例如 $$a = b + c$$
#         r'\\\(.+?\\\)',                  # 行内公式，例如 \(a = b + c\)
#         r'\\\[.+?\\\]',                  # 块级公式，例如 \[a = b + c\]
#         r'\\frac\s*{.*?}\s*{.*?}',       # LaTeX 分式，例如 \frac{a}{b}
#         r'[a-zA-Z]\s*_\s*{.*?}',         # 下标公式，例如 a_{n}
#         r'[a-zA-Z]\s*\^\s*{.*?}',        # 上标公式，例如 a^{2}
#         r'[a-zA-Z]\s*=\s*.+',            # 常见赋值公式，例如 a = b + c
#         r'\\int\s*.*',                   # 积分公式，例如 \int_{a}^{b} x^2 dx
#         r'\\sum\s*.*',                   # 求和公式，例如 \sum_{i=1}^n i
#         r'\\prod\s*.*',                  # 求积公式，例如 \prod_{i=1}^n i
#         r'\\lim\s*.*',                   # 极限公式，例如 \lim_{x \to 0} f(x)
#         r'\\sqrt\s*{.*?}',               # 平方根，例如 \sqrt{x}
#         r'\\log\s*.*',                   # 对数公式，例如 \log_{2}x
#         r'\\sin|\\cos|\\tan|\\arcsin|\\arccos|\\arctan',  # 三角函数
#         r'\\left.*?\\right',             # 带括号的公式，例如 \left( x+y \right)
#         r'\\mathrm\s*{.*?}',             # LaTeX 数学字体控制，例如 \mathrm{sin}
#         r'\\overline\s*{.*?}',           # 上划线，例如 \overline{AB}
#         r'\\underline\s*{.*?}',          # 下划线，例如 \underline{AB}
#         r'\\cdot|\\times|\\div|\\pm',    # 运算符，例如 \cdot, \times, \div, \pm
#         r'[a-zA-Z]\s*\\to\s*.*',         # 函数关系，例如 x \to y
#     ]
    
#     # 组合所有正则进行检测
#     for pattern in formula_patterns:
#         if re.search(pattern, markdown_info, re.DOTALL):
#             return True
    
#     return False

def mkdir_if_not_exist(path):
    if not os.path.exists(path):
        os.makedirs(path)
# 将日志信息保存为 JSON 文件
def save_logs_to_file(logs_info, file_name=None):
    if file_name==None:
        return False
    with open(file_name, 'w', encoding='utf-8') as file:
        json.dump(logs_info, file, ensure_ascii=False, indent=4)
    return True

def encode_image(image_path):
    with open(image_path, "rb") as image_file:
        return base64.b64encode(image_file.read()).decode('utf-8')
        
# 获取毫秒级时间
def get_millisecond_time():
    current_time = datetime.now()
    time_str = current_time.strftime("%Y%m%d%H%M%S%f")[:-3]
    return time_str

def get_lang(text):
    lang_detect, _ = langid.classify(text.replace('。', ' ').replace('，', ' '))  # 语言检测
    return 'en' if lang_detect == 'en' else 'zh'

def get_day_time():
    # 获取当前日期和时间
    now = datetime.now()
    # 格式化日期和时间为字符串，格式为 "YYYYMMDD_HHMMSS"
    formatted_time = now.strftime("%Y%m%d_%H%M%S")
    return formatted_time
    
def merge_ver_boxes(formula_positions):
    def sort_by_y_min(box):
        return box[2][1]
    
    formula_positions.sort(key=sort_by_y_min)

    merged_boxes = []
    current_box = None

    for box in formula_positions:
        category, confidence, bbox = box
        x_min, y_min, x_max, y_max = bbox

        if current_box is None:
            current_box = [category, confidence, bbox]
        else:
            curr_x_min, curr_y_min, curr_x_max, curr_y_max = current_box[2]

            if y_min <= curr_y_max:
                # Merge the boxes
                merged_bbox = [
                    min(curr_x_min, x_min),
                    min(curr_y_min, y_min),
                    max(curr_x_max, x_max),
                    max(curr_y_max, y_max)
                ]
                current_box[2] = merged_bbox
            else:
                # Append the current box to merged_boxes list and start a new current_box
                merged_boxes.append(current_box)
                current_box = [category, confidence, bbox]

    if current_box is not None:
        merged_boxes.append(current_box)

    return merged_boxes

def is_break(text):
    # 定义关键词列表
    keywords = [
        '答','选择','填空','选择题','填空题','分析','求解','计算','化简','证明',  '解', '例题', '名师经验谈',  '解析',  '答案','练习', 'A.','B.','C.','D.','(1)','(2)','(3)','(4)','(5)','(6)','(7)',
    ]
    
    # 检查关键词是否存在于文本中
    for keyword in keywords:
        if keyword in text:
            return False  # 如果发现关键词，返回 False
    
    return True  # 如果所有关键词都不存在，返回 True
import re

# def check_numbers_in_string(text):
#     """
#     检查字符串中的数字，如果包含大于10的数字返回False，否则返回True。

#     :param text: 输入的字符串
#     :return: 布尔值
#     """
#     # 提取字符串中的所有数字
#     numbers = re.findall(r'\d+', text)
#     print(numbers)
#     # 转换为整数类型
#     int_numbers = [int(num) for num in numbers]
    
#     # 检查是否存在大于10的数字
#     for num in int_numbers:
#         if num >= 5:
#             return False
#     return True
def check_numbers_in_string(text):
    """
    检查字符串中的数字，如果包含大于或等于5的数字返回False，否则返回True。

    :param text: 输入的字符串
    :return: 布尔值
    """
    # 提取字符串中的所有数字，包括中间可能有空格的情况
    numbers = re.findall(r'\d(?:\s*\d)*', text)  # 匹配数字，允许中间有空格
    #print("提取的原始数字:", numbers)
    
    # 去除空格并转换为整数类型
    int_numbers = [int(num.replace(' ', '')) for num in numbers]
    #print("转换为整数后的数字:", int_numbers)
    
    # 检查是否存在大于或等于5的数字
    for num in int_numbers:
        if num >= 5:
            return False
    return True
def process_text(text):
    """
    去除文本中的所有空行，并按照换行符进行分割。
    
    :param text: 输入的多行字符串
    :return: 去除空行后按 \n 分割的列表
    """
    # 去除空行
    non_empty_lines = [line for line in text.splitlines() if line.strip()]
    
    return non_empty_lines

def Scan_Content_Aggregation(all_page_details):
    
    all_results_markdown=[]
    all_lines_info=process_text(all_page_details)
    #all_page_details=[[{},{}],[{},{}]]
    #过滤内容
    print(all_lines_info)
    for line in all_lines_info:
        
        if not is_break(line):
            continue
        if not check_numbers_in_string(line):
            continue
        all_results_markdown.append(line)
    
    return '\n'.join(all_results_markdown)

    
class Singleton(type):
    _instances = {}

    def __call__(cls, *args, **kwargs):
        if cls not in cls._instances:
            cls._instances[cls] = super().__call__(*args, **kwargs)
        return cls._instances[cls]
    
if __name__=="__main__":
    original_text = "\\frac { \\sqrt { a } } { \\sqrt { b } } = \\sqrt { \\frac { a } { b } } ( a \\geq 0 , b > 0 )"

    cleaned_text = check_numbers_in_string(original_text)
    print(repr(cleaned_text))

