package com.pcloud.book.book.facade;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.codehaus.jackson.JsonParseException;

import com.pcloud.book.book.entity.BookAssistTemplet;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2017年7月5日,下午5:38:14 @版本：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookAssistTempletFacadeCloud", path = "book/v1.0/bookAssistTempletFacade")
@Api(description = "运营模板外部服务")
public interface BookAssistTempletFacade {

	/**
	 * 新增
	 * 
	 * @param token	用户信息
	 * @param bookAssistTemplet	对象
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	/*@ApiOperation(value = "新增", httpMethod = "POST")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookAssistTemplet", value = "模板分类实体", dataType = "BookAssistTemplet", paramType = "body") })
	@RequestMapping(value = "/insert", method = RequestMethod.POST)
	public ResponseDto<BookAssistTemplet> insert(@RequestHeader("token") String token,
			@RequestBody BookAssistTemplet bookAssistTemplet) throws BizException, PermissionException, JsonParseException;*/

	/**
	 * 删除
	 * 
	 * @param token	用户信息
	 * @param assistTempletId	对象标识
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
/*	@ApiOperation(value = "删除", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "assistTempletId", value = "运营模板ID", dataType = "long", paramType = "query") })
	@RequestMapping(value = "/deleteById", method = RequestMethod.GET)
	public ResponseDto<?> deleteById(@RequestHeader("token") String token,
			@RequestParam(required = false, value = "assistTempletId") Long assistTempletId)
			throws BizException, PermissionException, JsonParseException;*/

	/**
	 * 修改
	 * 
	 * @param token	用户信息
	 * @param bookAssistTemplet	对象
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
/*	@ApiOperation(value = "修改", httpMethod = "POST")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookAssistTemplet", value = "运营模板实体", dataType = "BookAssistTemplet", paramType = "body") })
	@RequestMapping(value = "/update", method = RequestMethod.POST)
	public ResponseDto<BookAssistTemplet> update(@RequestHeader("token") String token,
			@RequestBody BookAssistTemplet bookAssistTemplet) throws BizException, PermissionException, JsonParseException;*/

	/**
	 * 获取单个
	 * 
	 * @param token	用户信息
	 * @param assistTempletId	对象标识
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	/*@ApiOperation(value = "获取单个", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "assistTempletId", value = "运营模板ID", dataType = "long", paramType = "query") })
	@RequestMapping(value = "/getById", method = RequestMethod.GET)
	public ResponseDto<BookAssistTemplet> getById(@RequestHeader(required = false, value = "token") String token,
			@RequestParam(required = false, value = "assistTempletId") Long assistTempletId)
			throws BizException, PermissionException, JsonParseException;*/

	/**
	 * 获取列表
	 * 
	 * @param token	用户信息
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	/*@ApiOperation(value = "获取列表", httpMethod = "GET")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header") })
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	public ResponseDto<List<BookAssistTemplet>> list(@RequestHeader("token") String token)
			throws BizException, PermissionException, JsonParseException;*/


	
}
