package com.pcloud.book.keywords.dao.impl;

import com.google.common.collect.Maps;

import com.pcloud.book.group.vo.SyncKeyworsVO;
import com.pcloud.book.keywords.dao.BookKeywordDao;
import com.pcloud.book.keywords.dto.KeywordDTO;
import com.pcloud.book.keywords.dto.ReplyKeywordDTO;
import com.pcloud.book.keywords.entity.BookKeyword;
import com.pcloud.book.keywords.vo.KeywordVO;
import com.pcloud.book.keywords.vo.ListKeywordVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/25 11:50
 */
@Component("bookKeywordDao")
public class BookKeywordDaoImpl extends BaseDaoImpl<BookKeyword> implements BookKeywordDao {
    @Override
    public void deleteById(Long keywordId, Long partyId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("keywordId", keywordId);
        paramMap.put("updateUser", partyId);
        this.getSqlSession().update(this.getStatement("deleteById"), paramMap);
    }

    @Override
    public void setRank(BookKeyword bookKeyword) {
        this.getSqlSession().update(this.getStatement("setRank"), bookKeyword);
    }

    @Override
    public Integer getMaxRank(Long bookGroupId, Long classifyId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookGroupId", bookGroupId);
        paramMap.put("classifyId", classifyId);
        return this.getSqlSession().selectOne(this.getStatement("getMaxRank"), paramMap);
    }

    @Override
    public List<KeywordDTO> listFiveKeyword(Long classifyId, Long bookGroupId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("classifyId", classifyId);
        paramMap.put("bookGroupId", bookGroupId);
        return this.getSqlSession().selectList(this.getStatement("listFiveKeyword"), paramMap);
    }

    @Override
    public ReplyKeywordDTO getKeywordId(Long classifyId, Long bookGroupId, String content) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("classifyId", classifyId);
        paramMap.put("bookGroupId", bookGroupId);
        paramMap.put("content", content);
        return this.getSqlSession().selectOne(this.getStatement("getKeywordId"), paramMap);
    }

    @Override
    public Boolean checkKeyword(String keywords, Long classifyId, Long bookGroupId, Long keywordId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("classifyId", classifyId);
        paramMap.put("bookGroupId", bookGroupId);
        paramMap.put("keywords", keywords);
        paramMap.put("keywordId", keywordId);
        return this.getSqlSession().selectOne(this.getStatement("checkKeyword"), paramMap);
    }

    @Override
    public KeywordVO getByBookKeyword(Long bookKeywordId) {
        return this.getSqlSession().selectOne(this.getStatement("getByBookKeyword"), bookKeywordId);
    }

    @Override
    public void updateIsWarehouse(Long bookKeywordId, Long warehouseId) {
        final Map<String, Object> map = Maps.newHashMap();
        map.put("bookKeywordId", bookKeywordId);
        map.put("warehouseId", warehouseId);
        this.getSqlSession().update("updateIsWarehouse", map);
    }

    @Override
    public Integer getKeywordCount(Long bookGroupId, Long classifyId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookGroupId", bookGroupId);
        paramMap.put("classifyId", classifyId);
        return this.getSqlSession().selectOne(this.getStatement("getKeywordCount"), paramMap);
    }

    @Override
    public List<ListKeywordVO> getKeywordsByClassifyIds(List<Long> classifyIds, Long bookId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("classifyIds", classifyIds);
        paramMap.put("bookId", bookId);
        return this.getSqlSession().selectList(this.getStatement("getKeywordsByClassifyIds"), paramMap);
    }

    @Override
    public List<SyncKeyworsVO> getKeywordsIdsByBookGroupId(Long bookGroupId, Long classifyId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookGroupId", bookGroupId);
        paramMap.put("classifyId", classifyId);
        return this.getSqlSession().selectList(this.getStatement("getKeywordsIdsByBookGroupId"), paramMap);
    }

    @Override
    public void deleteKeywords(Long keywordId, Long bookGroupId, Long classifyId, Long partyId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("keywordId", keywordId);
        paramMap.put("bookGroupId", bookGroupId);
        paramMap.put("classifyId", classifyId);
        paramMap.put("partyId", partyId);
        this.getSqlSession().update(this.getStatement("deleteKeywords"), paramMap);
    }
}
