package com.pcloud.book.keywords.vo;

import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/23 15:27
 */
@ApiModel
public class SetGuideVO implements Serializable {

    @ApiModelProperty("社群码标识")
    private Long bookGroupId;

    @ApiModelProperty("分类标识")
    private Long classifyId;

    @ApiModelProperty("设置类型 0 按书  1 按分类")
    private Integer setType;

    @ApiModelProperty("是否推荐公众号（0 不推荐 1推荐）")
    private Integer isRecommend;

    @ApiModelProperty("推荐语")
    private String recommendLanguage;

    @ApiModelProperty("回复消息")
    private List<ReplyMessageVO> replyMessages;

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Integer getSetType() {
        return setType;
    }

    public void setSetType(Integer setType) {
        this.setType = setType;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Integer getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Integer isRecommend) {
        this.isRecommend = isRecommend;
    }

    public String getRecommendLanguage() {
        return recommendLanguage;
    }

    public void setRecommendLanguage(String recommendLanguage) {
        this.recommendLanguage = recommendLanguage;
    }

    public List<ReplyMessageVO> getReplyMessages() {
        return replyMessages;
    }

    public void setReplyMessages(List<ReplyMessageVO> replyMessages) {
        this.replyMessages = replyMessages;
    }

    @Override
    public String toString() {
        return "SetGuideVO{" +
                "bookGroupId=" + bookGroupId +
                ", classifyId=" + classifyId +
                ", setType=" + setType +
                ", isRecommend=" + isRecommend +
                ", recommendLanguage='" + recommendLanguage + '\'' +
                ", replyMessages=" + replyMessages +
                '}';
    }
}
