package com.pcloud.book.push.dao.impl;

import com.pcloud.book.push.dao.PushGroupDao;
import com.pcloud.book.push.dto.PlanClassifyDTO;
import com.pcloud.book.push.entity.PushGroup;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:36
 **/
@Repository("pushGroupDao")
public class PushGroupDaoImpl extends BaseDaoImpl<PushGroup> implements PushGroupDao {
    @Override
    public Integer batchInsert(List<PushGroup> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public List<PushGroup> getListByPushId(Long pushId) {
        return super.getSqlSession().selectList(getStatement("getListByPushId"), pushId);
    }

    @Override
    public void deleteByPushId(Long pushId, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushId",pushId);
        map.put("partyId",partyId);
        super.getSqlSession().update(getStatement("deleteByPushId"), map);
    }

    @Override
    public void deleteByIds(List<Long> ids, Long partyId) {
        Map<String, Object> map = new HashMap<>();
        map.put("ids",ids);
        map.put("partyId",partyId);
        super.getSqlSession().update(getStatement("deleteByIds"), map);
    }

    @Override
    public List<PushGroup> getListByPushIds(List<Long> pushIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushIds",pushIds);
        return super.getSqlSession().selectList(getStatement("getListByPushIds"), map);
    }

    @Override
    public List<PlanClassifyDTO> getPlanClassifyListByPlanIds(List<Long> pushPlanIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushPlanIds",pushPlanIds);
        return super.getSqlSession().selectList(getStatement("getPlanClassifyListByPlanIds"), map);
    }

    @Override
    public List<PushGroup> getListByClassifyId(Long classifyId) {
        return super.getSqlSession().selectList(getStatement("getListByClassifyId"), classifyId);
    }

    @Override
    public List<PlanClassifyDTO> getPlanClassifyListByPlanId(Long pushPlanId) {
        return super.getSqlSession().selectList(getStatement("getPlanClassifyListByPlanId"), pushPlanId);
    }
}
