package com.pcloud.book.adnews.service;

import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

@FeignClient(value = "pcloud-service-book", qualifiers = "adNewsServiceCloud", path = "book/v1.0/adNewsService")
@Api(description = "编辑端早晚报内部接口")
public interface AdNewsService {

    @ApiOperation("发送编辑端早晚报")
    @PostMapping("/sendAdNews")
    void sendAdNews(@RequestBody Map<String, Object> map) throws BizException;

}
