package com.pcloud.book.appeal.entity;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.book.entity.BookDefendant;
import com.pcloud.common.entity.BaseEntity;

/** 
  *  书刊申诉
  *  @author:lili
  *  @date 创建时间：2017年3月30日 下午3:13:03 
  *  @version 1.0 
  *  @return  
  */
public class BookAppeal extends BaseEntity{

	/**
	 * 序列化
	 */
	private static final long serialVersionUID = -7469866596403135281L;

	/**
	 * 图书申诉标识
	 */
	private Long bookAppealId;
	
	/**
	 * 图书标识
	 */
	private Long bookId;
	
	/**
	 * 渠道标识
	 */
	private Long channelId;
	
	/**
	 * 图书类型标识
	 */
	private Long templetId;

	/**
	 * 二级分类标识
	 */
	private Long secondTempletId;

	/**
	 * 三级分类id
	 */
	private Long thirdTempletId;
	/**
	 * 三级分类名称
	 */
	private String thirdTempletName;

	/**
	 * 申诉理由
	 */
	private String reason;
	
	/**
	 * 申诉人
	 */
	private Long declarant;
	
	/**
	 * 联系方式
	 */
	private String phone;
	
	/**
	 * 申诉提交时间
	 */
	private Date appealSubmitDate;
	
	/**
	 * 申诉状态
	 */
	private Integer appealState;
	
	/**
	 * 审核原因
	 */
	private String auditReason;
	
	/**
	 * 审核人
	 */
	private Long auditUser;
	
	/**
	 * 创建人
	 */
	private Long createdUser;
	
	/**
	 * 创建时间
	 */
	private Date createdDate;
	
	/**
	 * 最后修改人
	 */
	private Long lastModifiedUser;
	
	/**
	 * 最后修改时间
	 */
	private Date lastModifiedDate;
	
	/**
	 * 被诉方
	 */
	private List<BookDefendant> defendant;

    /**
     * 是否社群书
     */
	private Boolean isBookGroup;

	/**
	 * 新增类型
	 */
	private Integer addType;


	public Long getThirdTempletId() {
		return thirdTempletId;
	}

	public void setThirdTempletId(Long thirdTempletId) {
		this.thirdTempletId = thirdTempletId;
	}

	public String getThirdTempletName() {
		return thirdTempletName;
	}

	public void setThirdTempletName(String thirdTempletName) {
		this.thirdTempletName = thirdTempletName;
	}

	public Long getBookAppealId() {
		return bookAppealId;
	}

	public void setBookAppealId(Long bookAppealId) {
		this.bookAppealId = bookAppealId;
	}

	public Long getBookId() {
		return bookId;
	}

	public void setBookId(Long bookId) {
		this.bookId = bookId;
	}

	public Long getChannelId() {
		return channelId;
	}

	public void setChannelId(Long channelId) {
		this.channelId = channelId;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public Long getDeclarant() {
		return declarant;
	}

	public void setDeclarant(Long declarant) {
		this.declarant = declarant;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public Date getAppealSubmitDate() {
		return appealSubmitDate;
	}

	public void setAppealSubmitDate(Date appealSubmitDate) {
		this.appealSubmitDate = appealSubmitDate;
	}

	public Integer getAppealState() {
		return appealState;
	}

	public void setAppealState(Integer appealState) {
		this.appealState = appealState;
	}

	public String getAuditReason() {
		return auditReason;
	}

	public void setAuditReason(String auditReason) {
		this.auditReason = auditReason;
	}

	public Long getCreatedUser() {
		return createdUser;
	}

	public void setCreatedUser(Long createdUser) {
		this.createdUser = createdUser;
	}

	public Long getAuditUser() {
		return auditUser;
	}

	public void setAuditUser(Long auditUser) {
		this.auditUser = auditUser;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Long getLastModifiedUser() {
		return lastModifiedUser;
	}

	public void setLastModifiedUser(Long lastModifiedUser) {
		this.lastModifiedUser = lastModifiedUser;
	}

	public Date getLastModifiedDate() {
		return lastModifiedDate;
	}

	public void setLastModifiedDate(Date lastModifiedDate) {
		this.lastModifiedDate = lastModifiedDate;
	}

	public List<BookDefendant> getDefendant() {
		return defendant;
	}

	public void setDefendant(List<BookDefendant> defendant) {
		this.defendant = defendant;
	}

	public Long getTempletId() {
		return templetId;
	}

	public void setTempletId(Long templetId) {
		this.templetId = templetId;
	}

    public Boolean getIsBookGroup() {
        return isBookGroup;
    }

    public void setIsBookGroup(Boolean isBookGroup) {
        this.isBookGroup = isBookGroup;
    }

	public Integer getAddType() {
		return addType;
	}

	public void setAddType(Integer addType) {
		this.addType = addType;
	}

	public Long getSecondTempletId() {
		return secondTempletId;
	}

	public void setSecondTempletId(Long secondTempletId) {
		this.secondTempletId = secondTempletId;
	}

	@Override
	public String toString() {
		return "BookAppeal{" +
				"bookAppealId=" + bookAppealId +
				", bookId=" + bookId +
				", channelId=" + channelId +
				", templetId=" + templetId +
				", secondTempletId=" + secondTempletId +
				", reason='" + reason + '\'' +
				", declarant=" + declarant +
				", phone='" + phone + '\'' +
				", appealSubmitDate=" + appealSubmitDate +
				", appealState=" + appealState +
				", auditReason='" + auditReason + '\'' +
				", auditUser=" + auditUser +
				", createdUser=" + createdUser +
				", createdDate=" + createdDate +
				", lastModifiedUser=" + lastModifiedUser +
				", lastModifiedDate=" + lastModifiedDate +
				", defendant=" + defendant +
				", isBookGroup=" + isBookGroup +
				", addType=" + addType +
				'}';
	}
}
