/**
 *
 */
package com.pcloud.book.book.service;

import com.pcloud.book.book.dto.BookProductDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2016年12月23日,下午4:35:23 @版本：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifiers = "bookProductServiceCloud", path = "book/v1.0/bookProductService")
@Api(description = "书籍作品内部服务")
public interface BookProductService {

    /**
     * 获取书籍关联的作品
     *
     * @param bookId
     * @return
     */
    @ApiOperation(value = "获取书籍关联的作品", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getMapById", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<Map<Long, BookProductDto>>> getMapById(
            @RequestParam(value = "bookId", required = false) Long bookId,
            @RequestParam(value = "adviserId", required = false) Long adviserId,
            @RequestParam(value = "channelId", required = false) Long channelId) throws BizException;

}
