package com.pcloud.book.copyright.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author lily
 * @date 2018/12/17 15:17
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookAuthTotalCountDTO implements Serializable {

    @ApiModelProperty("购买数量")
    private Integer payUserCount;

    @ApiModelProperty("使用正版授权码数量")
    private Integer codeUserCount;

    @ApiModelProperty("总使用数")
    private Integer totalCount;

    @ApiModelProperty("开启总数")
    private Integer openCount;

    @ApiModelProperty("点击购买链接人数")
    private Integer clickBuyCount;

    public Integer getPayUserCount() {
        return payUserCount;
    }

    public void setPayUserCount(Integer payUserCount) {
        this.payUserCount = payUserCount;
    }

    public Integer getCodeUserCount() {
        return codeUserCount;
    }

    public void setCodeUserCount(Integer codeUserCount) {
        this.codeUserCount = codeUserCount;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getOpenCount() {
        return openCount;
    }

    public void setOpenCount(Integer openCount) {
        this.openCount = openCount;
    }

    public Integer getClickBuyCount() {
        return clickBuyCount;
    }

    public void setClickBuyCount(Integer clickBuyCount) {
        this.clickBuyCount = clickBuyCount;
    }

    @Override
    public String toString() {
        return "BookAuthTotalCountDTO{" +
                "payUserCount=" + payUserCount +
                ", codeUserCount=" + codeUserCount +
                ", totalCount=" + totalCount +
                ", openCount=" + openCount +
                ", clickBuyCount=" + clickBuyCount +
                '}';
    }
}
