package com.pcloud.book.group.service;

import com.pcloud.book.group.dto.ReplyMsgDTO;
import com.pcloud.common.dto.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "pcloud-service-book", qualifiers = "wxWorkKeyWordServiceCloud", path = "book/v1.0/wxWorkKeyWordService")
@Api(description = "关键词内部接口")
public interface WxWorkKeyWordService {

    @ApiOperation("根据bookGroupId获取关键词回复")
    @GetMapping("/getKeyWordsByBookGroupId")
    ResponseEntity<ResponseDto<List<ReplyMsgDTO>>> getKeyWordsByBookGroupId(@RequestParam("bookGroupId") Long bookGroupId);

}
