package com.pcloud.book.riddle.enums;

/**
 * @描述：回复文案类型
 * @作者：zhuyajie
 * @创建时间：16:56 2019/7/24
 * @版本：1.0
 */
public enum RiddleReplyTypeEnum {


    /**
     * 游戏规则
     */
    rule("rule"),
    /**
     * 无人回复的结束语
     */
    no_reply_end("no_reply_end"),
    /**
     * 答完全部题结束语
     */
    finish_end("finish_end"),
    /**
     * 中途回复关键词
     */
    midway_in("midway_in"),
    /**
     * 答对
     */
    correct("correct"),
    /**
     * 答错
     */
    incorrect("incorrect"),
    /**
     * 部分正确
     */
    partly_correct("partly_correct");


    private String code;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    RiddleReplyTypeEnum(String code) {
        this.code = code;
    }
}
