package com.pcloud.book.advertising.biz;

import com.pcloud.book.advertising.dto.AddAdvertisingBrandBooksDTO;
import com.pcloud.book.advertising.dto.BookListForAdvertisingDTO;
import com.pcloud.book.advertising.dto.BrandDataDTO4Channel;
import com.pcloud.book.advertising.entity.AdvertisingBrandBook;
import com.pcloud.book.advertising.dto.BrandDataParamDTO;
import com.pcloud.book.advertising.entity.AdvertisingBrandData;
import com.pcloud.common.page.PageBeanNew;

import java.util.Map;

import java.util.List;

/**
 * @描述：品牌方数据修改
 * @作者：zhuyajie
 * @创建时间：11:56 2020/4/16
 * @版本：1.0
 */
public interface AdvertisingBrandDataBiz {

    /**
     * 添加品牌方数据
     */
    public void addBrandData(BrandDataParamDTO brandDataParamDTO);

    /**
     * 获取品牌方数据
     * @param advertisingBrandData
     * @return
     */
    Map<String,Integer>getBrandData(AdvertisingBrandData advertisingBrandData);

    void addAdvertisingBrandBooks(AddAdvertisingBrandBooksDTO addAdvertisingBrandBooksDTO);

    void deleteAdvertisingBrandBooksByBookIds(List<Long> bookIds);

    PageBeanNew<BookListForAdvertisingDTO> getBookListForAdvertising(Integer currentPage, Integer numPerPage, String keyword, Long advertisingBrandId, Boolean isPitch, Boolean is1v1);

    /**
     * 品牌方增加的二维码下资源数据
     * @param brandDataDTO4Channel
     * @return
     */
    Map<Long, BrandDataDTO4Channel> mapBrandQrServeAddData(BrandDataDTO4Channel brandDataDTO4Channel);

    /**
     * 品牌方增加的二维码数据
     * @param brandDataDTO4Channel
     * @return
     */
    Map<Long, BrandDataDTO4Channel> mapBrandQrAddData(BrandDataDTO4Channel brandDataDTO4Channel);

    List<Long> getAdvertisingBrandBooksIds(Long advertisingBrandId);
}
