package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.entity.AdvertisingBrowseRecord;
import com.pcloud.common.core.dao.BaseDao;

/**
 * Description 广告位浏览记录数据访问层接口
 * @author zhuyajie
 * @date 2019/7/11
 */
public interface AdvertisingBrowseRecordDao extends BaseDao<AdvertisingBrowseRecord> {


    /**
     * 更新浏览时长
     * @param recordId
     * @param browseTimes
     */
    public void addBrowseTimesByRecordId(String recordId, Long browseTimes);


    /**
     * 查微信群浏览时长
     * @param qrcodeId
     * @param adId
     * @param statisMonth
     * @return
     */
    Long getBrowseTimesByQrcode(Long qrcodeId, Long adId, String statisMonth);

    /**
     * 查微信群浏览人数
     * @param qrcodeId
     * @param adId
     * @param statisMonth
     * @return
     */
    Long getBrowseUserCountByQrcode(Long qrcodeId, Long adId, String statisMonth);

    /**
     * 查书刊浏览时长
     * @param bookId
     * @param adviserId
     * @param channelId
     * @return
     */
    Long getBrowseTimesByBook(Long bookId, Long adviserId, Long channelId, Long adId, String statisMonth);

    /**
     * 查书刊浏览人数
     * @param bookId
     * @param adviserId
     * @param channelId
     * @return
     */
    Long getBrowseUserCountByBook(Long bookId, Long adviserId, Long channelId, Long adId, String statisMonth);
}
