package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.dto.QrcodeAdvertisingSpaceCountDTO;
import com.pcloud.book.advertising.entity.AdvertisingDistributionBook;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * Description 广告位投放书籍数据访问层接口
 * @author PENG
 * @date 2019/2/28
 */
public interface AdvertisingDistributionBookDao extends BaseDao<AdvertisingDistributionBook> {

    /**
     * 批量新增
     * @param list 列表
     * @return
     */
    long batchInsert(List<AdvertisingDistributionBook> list);

    /**
     * 校验广告位是否已投放微信群
     * @param paramMap 参数Map
     * @return
     */
    List<Long> checkQrcodeIdExist(Map<String, Object> paramMap);

    /**
     * 获取广告位投放的书刊列表
     * @param adId 广告位ID
     * @return
     */
    List<AdvertisingDistributionBook> getByAdId(Long adId);

    /**
     * 获取广告位数量
     * @param qrcodeIds
     * @return
     */
    Map<Long, QrcodeAdvertisingSpaceCountDTO> mapAdvertisingSpaceNum(List<Long> qrcodeIds);

    /**
     * 查渠道编辑id
     * @param adId
     * @param bookId
     * @return
     */
    public AdvertisingDistributionBook getChannelIdByAdIdBookId(Long adId, Long bookId);
}
