package com.pcloud.book.advertising.facade;

import com.pcloud.book.advertising.biz.AdvertisingBrandDataBiz;
import com.pcloud.book.advertising.dto.AddAdvertisingBrandBooksDTO;
import com.pcloud.book.advertising.dto.BrandDataParamDTO;
import com.pcloud.book.advertising.entity.AdvertisingBrandBook;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @描述：品牌方数据修改
 * @作者：zhuyajie
 * @创建时间：12:06 2020/4/16
 * @版本：1.0
 */
@Api(description = "品牌方数据修改外部接口")
@RequestMapping(value = "/brandData")
@RestController("advertisingBrandData")
public class AdvertisingBrandDataFacade {

    @Autowired
    private AdvertisingBrandDataBiz advertisingBrandDataBiz;

    @ApiOperation("添加品牌方数据")
    @PostMapping("addBrandData")
    public ResponseDto<?> addBrandData(@RequestHeader("token") String token, @RequestBody @ApiParam BrandDataParamDTO brandDataParamDTO) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        advertisingBrandDataBiz.addBrandData(brandDataParamDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("添加品牌方和书的关联关系")
    @PostMapping("addAdvertisingBrandBooks")
    public ResponseDto<?> addAdvertisingBrandBooks(
            @RequestHeader("token") String token,
            @RequestBody AddAdvertisingBrandBooksDTO addAdvertisingBrandBooksDTO
    ) throws PermissionException, BizException, JsonParseException {
        SessionUtil.getToken4Redis(token);
        advertisingBrandDataBiz.addAdvertisingBrandBooks(addAdvertisingBrandBooksDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("获取品牌方已经标记的书id集合")
    @GetMapping("getAdvertisingBrandBooksIds")
    public ResponseDto<?> getAdvertisingBrandBooksIds(
            @RequestHeader("token") String token,
            @RequestParam("advertisingBrandId") Long advertisingBrandId
    ) throws PermissionException, BizException, JsonParseException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(advertisingBrandDataBiz.getAdvertisingBrandBooksIds(advertisingBrandId));
    }

    @ApiOperation("按书id批量删除品牌方和书的关联关系")
    @PostMapping("deleteAdvertisingBrandBooksByBookIds")
    public ResponseDto<?> deleteAdvertisingBrandBooksByBookIds(
            @RequestHeader("token") String token,
            @RequestBody List<Long> bookIds
    ) throws PermissionException, BizException, JsonParseException {
        SessionUtil.getToken4Redis(token);
        advertisingBrandDataBiz.deleteAdvertisingBrandBooksByBookIds(bookIds);
        return new ResponseDto<>();
    }

    @ApiOperation("获取品牌方书刊列表")
    @GetMapping("getBookListForAdvertising")
    public ResponseDto<?> getBookListForAdvertising(
            @RequestHeader("token") String token,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage,
            @RequestParam(value = "keyword", required = false) String keyword,
            @RequestParam(value = "advertisingBrandId", required = false) Long advertisingBrandId,
            @RequestParam(value = "isPitch", required = false) Boolean isPitch,
            @RequestParam(value = "is1v1", required = false) Boolean is1v1
    ) throws PermissionException, BizException, JsonParseException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(advertisingBrandDataBiz.getBookListForAdvertising(currentPage,numPerPage,keyword,advertisingBrandId,isPitch,is1v1));
    }

}
