package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletBookUserScoreDTO;
import com.pcloud.book.applet.dto.AppletFeedbackDTO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface AppletBookScoreBiz {

    /**
     * 为小程序本书服务评分
     *
     * @param wechatUserId 用户ID
     * @param bookId       图书ID
     * @param channelId    渠道ID
     * @param adviserId    编辑ID
     * @param scoreTagId   评价
     * @param subTagId     二级 标签ID
     * @return 主键ID
     */
    Long score(Long wechatUserId, Long bookId, Long channelId, Long adviserId, Long scoreTagId, Long subTagId);

    /**
     * 获取本书服务评价信息
     *
     * @param wechatUserId 用户ID
     * @param bookId       图书ID
     * @param channelId    渠道ID
     * @param adviserId    评价
     * @return 评价信息
     */
    List<AppletBookUserScoreDTO> get(Long wechatUserId, Long bookId, Long channelId, Long adviserId);

    /**
     * 用户本书服务反馈意见
     *
     * @param wechatUserId 用户ID
     * @param feedbackDTO  反馈意见
     * @return null
     */
    Void feedback(Long wechatUserId, AppletFeedbackDTO feedbackDTO);

    /**
     * 文件上传
     *
     * @param file 文件数组
     * @return 文件地址集合
     */
    List<String> uploadFile(MultipartFile[] file);

    /**
     * 导出本书服务评价数据
     *
     * @return 文件字节流
     */
    byte[] export();
}
