package com.pcloud.book.applet.biz.impl;

import com.google.common.collect.Lists;
import com.pcloud.book.applet.biz.AppletBusinessCardBiz;
import com.pcloud.book.applet.dao.AppletBusinessCardDao;
import com.pcloud.book.applet.dao.AppletNewsDao;
import com.pcloud.book.applet.dto.AppletGroupManageDTO;
import com.pcloud.book.applet.entity.AppletBusinessCard;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.dao.BookRaysClassifyDao;
import com.pcloud.book.group.vo.ClassifyQrcodeVO;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.string.StringUtilParent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * Created with IntelliJ IDEA.
 *
 * @Auther: Pansy
 * @Date: 2020/07/29/10:32
 * @Description:
 */
@Service("appletBusinessCardBiz")
public class AppletBusinessCardBizImpl implements AppletBusinessCardBiz {

    @Autowired
    private AppletBusinessCardDao appletBusinessCardDao;
    @Autowired
    private AppletNewsDao appletNewsDao;

    @Override
    public Long insert(AppletBusinessCard appletBusinessCard){
        return appletBusinessCardDao.insert(appletBusinessCard);
    }

    @Override
    public void deleteById(Long id){
//        if (appletNewsDao.getCountByBusinessCardId(id)>0){
//            throw new BookBizException(BookBizException.ERROR, "名片已绑定咨询不能删除");
//        }

        appletBusinessCardDao.deleteById(id);
    }

    @Override
    public void update(AppletBusinessCard appletBusinessCard){
        appletBusinessCardDao.update(appletBusinessCard);
    }

    @Override
    public  PageBeanNew getList(String keyword,Integer currentPage, Integer numPerPage){
        Map<String,Object> map = new HashMap<>();
        map.put("keyword", keyword);
        PageBeanNew<AppletBusinessCard> recordList = appletBusinessCardDao.listPageNew(new PageParam(currentPage, numPerPage), map, "getList");
        if (null == recordList || CollectionUtils.isEmpty(recordList.getRecordList())) {
            return recordList;
        }
        return recordList;
    }
}
