package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.AppletSubscribeCountBiz;
import com.pcloud.book.applet.dao.AppletSubscribeCountDao;
import com.pcloud.book.applet.entity.AppletSubscribeCount;
import com.pcloud.book.applet.enums.SubscribeCountTypeEnum;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * (AppletSubscribeCount)表服务实现类
 *
 * @author wubo
 * @since 2021-08-03 09:37:45
 */
@Service("appletSubscribeCountBiz")
public class AppletSubscribeCountBizImpl implements AppletSubscribeCountBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletSubscribeCountBizImpl.class);

    @Autowired
    private AppletSubscribeCountDao appletSubscribeCountDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletSubscribeCount getById(Long id) {
        return appletSubscribeCountDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletSubscribeCountDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(AppletSubscribeCount appletSubscribeCount) {
        appletSubscribeCountDao.insert(appletSubscribeCount);
        return appletSubscribeCount.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(AppletSubscribeCount appletSubscribeCount) {
        if (appletSubscribeCount == null || !NumberUtil.isNumber(appletSubscribeCount.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        appletSubscribeCountDao.update(appletSubscribeCount);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletSubscribeCountDao.deleteById(id);
    }

    @Override
    @ParamLog("软删除")
    public void softDeleteById(Long id) {
        appletSubscribeCountDao.softDeleteById(id);
    }

    @Override
    @ParamLog("获取用户订阅次数")
    public AppletSubscribeCount getByUserId(Long wechatUserId, Integer recordType) {
        return appletSubscribeCountDao.getByUserId(wechatUserId, recordType);
    }

    @Override
    @ParamLog("清零用户次数")
    public void clearSubscribeCount(Long wechatUserId, Integer recordType) {
        appletSubscribeCountDao.clearSubscribeCount(wechatUserId, recordType);
    }
}