package com.pcloud.book.applet.biz.impl;

import com.alibaba.fastjson.JSON;
import com.pcloud.book.applet.biz.AppletThirdResourcesStaticBiz;
import com.pcloud.book.applet.dao.AppletThirdResourcesStaticDao;
import com.pcloud.book.applet.dto.AppletThirdResourceQueryDTO;
import com.pcloud.book.applet.dto.AppletThirdResourceResponseDTO;
import com.pcloud.book.applet.dto.AppletThirdResourcesStaticDTO;
import com.pcloud.book.applet.dto.PageDto;
import com.pcloud.book.applet.entity.AppletThirdResourcesStatic;
import com.pcloud.book.applet.enums.AppletThirdResourceTypeEnum;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.group.tools.Kit;
import com.pcloud.book.util.common.YesOrNoEnums;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * (AppletThirdResourcesStatic)表服务实现类
 *
 * @author makejava
 * @since 2020-10-14 16:19:03
 */
@Service("appletThirdResourcesStaticBiz")
public class AppletThirdResourcesStaticBizImpl implements AppletThirdResourcesStaticBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletThirdResourcesStaticBizImpl.class);

    @Autowired
    private AppletThirdResourcesStaticDao appletThirdResourcesStaticDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletThirdResourcesStatic getById(Long id) {
        return appletThirdResourcesStaticDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletThirdResourcesStaticDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(AppletThirdResourcesStatic appletThirdResourcesStatic) {
        appletThirdResourcesStaticDao.insert(appletThirdResourcesStatic);
        return appletThirdResourcesStatic.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(AppletThirdResourcesStatic appletThirdResourcesStatic) {
        if (appletThirdResourcesStatic == null || !NumberUtil.isNumber(appletThirdResourcesStatic.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        appletThirdResourcesStaticDao.update(appletThirdResourcesStatic);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletThirdResourcesStaticDao.deleteById(id);
    }

    @Override
    @ParamLog("获取跟谁学统计数据")
    public void getAppletThirdResourceStatic(Integer isAll) {
        //20210831 接口调用不通 ，暂停调用
        /*PageBeanNew pageBeanNew = null;
        //PageBeanNew pageBeanNew = appletThirdResourcesStaticDao.listPageNew(new PageParam(0, 10), null, "getList");
        if (null != pageBeanNew && !ListUtils.isEmpty(pageBeanNew.getRecordList()) && YesOrNoEnums.YES.getValue().equals(isAll)) {
            throw new BookBizException(BookBizException.ERROR, "当统计数据表不为空时不能导入全部数据只能导入昨日数据");
        }
        AppletThirdResourceQueryDTO queryDTO = new AppletThirdResourceQueryDTO();
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(1);
        pageDto.setPageSize(100);
        queryDTO.setStage("PRIMARY");
        String  url = BookConstant.fissionChatRoomUrl;
        Integer resourceType = null;
        resourceType  = AppletThirdResourceTypeEnum.FISSIONCHATROOM.code;
        if (YesOrNoEnums.YES.getValue().equals(isAll)) {
            try {
                Date endDate = DateUtils.subDays(1000);
                insertResourceStatic(queryDTO, pageDto, url, endDate, resourceType);
                pageDto.setPageNum(2);
                insertResourceStatic(queryDTO, pageDto, url, endDate, resourceType);
                url =  BookConstant.chatRoomUrl;
                resourceType  = AppletThirdResourceTypeEnum.CHATROOM.code;
                pageDto.setPageNum(1);
                queryDTO.setStage("MIDDLE");
                insertResourceStatic(queryDTO, pageDto, url, endDate, resourceType);
                queryDTO.setStage("HIGH");
                insertResourceStatic(queryDTO, pageDto, url, endDate, resourceType);
            } catch (Exception e) {
                LOGGER.error("获取跟谁学统计数据失败", e);
            }
        } else {
            Date endDate = DateUtils.subDays(1);
            try {
                insertResourceStatic(queryDTO, pageDto, url, endDate, resourceType);
                url =  BookConstant.chatRoomUrl;
                resourceType  = AppletThirdResourceTypeEnum.CHATROOM.code;
                insertResourceStatic(queryDTO, pageDto, url, endDate, resourceType);
                queryDTO.setStage("MIDDLE");
                insertResourceStatic(queryDTO, pageDto, url, endDate, resourceType);
                queryDTO.setStage("HIGH");
                insertResourceStatic(queryDTO, pageDto, url, endDate, resourceType);
            } catch (ParseException e) {
                LOGGER.error("获取跟谁学统计数据失败", e);
            }
        }*/

    }

    private void insertResourceStatic(AppletThirdResourceQueryDTO queryDTO, PageDto pageDto, String url, Date endDate4Query, Integer resourceType) throws ParseException {
        String s = DateFormatUtils.format(new Date(), "yyyy-MM-dd 00:00:00");
        String s1 = DateFormatUtils.format(endDate4Query, "yyyy-MM-dd 00:00:00");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//定义时间格式
        Date endDate = sdf.parse(s);//将String字符串类型转换为date时间类型
        Date startDate = sdf.parse(s1);//将String字符串类型转换为date时间类型
        queryDTO.setStartTime(startDate.getTime());
        queryDTO.setEndTime(endDate.getTime());
        queryDTO.setPageDto(pageDto);
        String resultStr = Kit.post(url, JSON.toJSONString(queryDTO));
        AppletThirdResourceResponseDTO appletThirdResourceResponseDTO = JSON.parseObject(resultStr, AppletThirdResourceResponseDTO.class);
        if (null != appletThirdResourceResponseDTO && null != appletThirdResourceResponseDTO.getData()) {
            List<AppletThirdResourcesStaticDTO> list = appletThirdResourceResponseDTO.getData().getList();
            List<AppletThirdResourcesStatic> appletThirdResourcesStatics = new ArrayList<>();
            if (!ListUtils.isEmpty(list)) {
                BeanUtils.copyListProperties(list, appletThirdResourcesStatics, AppletThirdResourcesStatic.class);
                appletThirdResourcesStatics.stream().forEach(e -> e.setResourceType(resourceType));
                appletThirdResourcesStaticDao.insert(appletThirdResourcesStatics);
            }
        }
        LOGGER.info("=========resultStr========End" + resultStr);
    }
}