package com.pcloud.book.applet.contants;

/**
 * @ClassName com.pcloud.book.applet.contants.AppletResourceApplyConstants
 * @Author zhuyajie
 * @Description 资源适用范围
 * @Date 2021/5/8 14:54
 * @Version 1.0
 **/
public class AppletResourceApplyConstants {

    /**
     * 资源类型
     * @author：zhuyajie
     * @date：2021/5/8 15:03
     *  * @param null
     */
    public enum TargetTypeEnum {
        THIRD_RESOURCE("THIRD_RESOURCE"),
        BOOKLIST("BOOKLIST"),
        BANNER("BANNER"),
        TEACHER("TEACHER");

        private String value;

        public String getValue() {
            return value;
        }

        TargetTypeEnum(String value) {
            this.value = value;
        }
    }

    /**
     * 适用人群
     * @author：zhuyajie
     * @date：2021/5/8 15:03
     *  * @param null
     */
    public enum CrowdTypeEnum {
        PRESCHOOL(1,"学龄前"),
        PRIMARY_SCHOOL(2,"小学"),
        JUNIOR_HIGH_SCHOOL(3,"初中"),
        SENIOR_HIGH_SCHOOL(4,"高中"),
        UNIVERSITY(5, "大学"),
        ADULT(6,"成人");
        private Integer code;
        private String name;

        public Integer getCode() {
            return code;
        }

        public String getName() {
            return name;
        }

        CrowdTypeEnum(Integer code, String name) {
            this.code = code;
            this.name = name;
        }
    }
    /**
     * 内容类型
     * @author：zhuyajie
     * @date：2021/5/8 15:07
     *  * @param null
     */
    public enum ContentTypeEnum {
        ONLINE(1,"线上网课"),
        OFFILINE(2,"线下班"),
        GROUP(3,"社群"),
        RESOURCE(4,"资源服务");
        private Integer code;
        private String name;

        public Integer getCode() {
            return code;
        }

        public String getName() {
            return name;
        }

        ContentTypeEnum(Integer code, String name) {
            this.code = code;
            this.name = name;
        }
    }
}
