package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletNewsPoolBiz;
import com.pcloud.book.applet.dto.AppletNewsPoolDTO;
import com.pcloud.book.applet.entity.AppletNewsPool;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.SessionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.xml.ws.soap.Addressing;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("appletNewsPool")
public class AppletNewsPoolController {

    @Autowired
    private AppletNewsPoolBiz appletNewsPoolBiz;

    @GetMapping("getById")
    public ResponseDto<AppletNewsPool> getById(@RequestHeader("token") String token,
                                               @RequestParam("id") Long id){
        SessionUtil.getInfoToken4Redis(token);
        AppletNewsPool appletNewsPool = appletNewsPoolBiz.getById(id);
        return new ResponseDto<>(appletNewsPool);
    }

    @PostMapping("update")
    public ResponseDto<AppletNewsPool> update(@RequestHeader("token") String token,
                                               @RequestBody AppletNewsPool appletNewsPool){
        SessionUtil.getInfoToken4Redis(token);
        appletNewsPoolBiz.update(appletNewsPool);
        return new ResponseDto<>();
    }

    @PostMapping("batchDelete")
    public ResponseDto<AppletNewsPool> batchDelete(@RequestHeader("token") String token,
                                              @RequestBody List<Long> ids){
        SessionUtil.getInfoToken4Redis(token);
        appletNewsPoolBiz.batchDelete(ids);
        return new ResponseDto<>();
    }

    @GetMapping("listNewsPage")
    public ResponseDto<PageBeanNew<AppletNewsPool>> listNewsPage(@RequestHeader("token") String token,
                                                                 @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                                                 @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage,
                                                                 @RequestParam(value = "newsName", required = false) String newsName,
                                                                 @RequestParam(value = "source", required = false) String source){
        SessionUtil.getInfoToken4Redis(token);
        PageBeanNew<AppletNewsPool> appletNewsPoolPageBeanNew = appletNewsPoolBiz.listNewsPage(currentPage, numPerPage, newsName, source);
        return new ResponseDto<>(appletNewsPoolPageBeanNew);
    }

    @GetMapping("listSource")
    public ResponseDto<List<String>> listSource(@RequestHeader("token") String token){
        SessionUtil.getInfoToken4Redis(token);
        List<String> sources = appletNewsPoolBiz.listSource();
        return new ResponseDto<>(ListUtils.isEmpty(sources) ? new ArrayList<>() : sources);
    }

    @PostMapping("batchImport")
    public ResponseDto<Void> batchImport(@RequestHeader("token") String token,
                                     @RequestBody AppletNewsPoolDTO appletNewsPoolDTO) {
        SessionUtil.getInfoToken4Redis(token);
        appletNewsPoolBiz.batchImport(appletNewsPoolDTO);
        return new ResponseDto<>();
    }

}
