package com.pcloud.book.applet.mapper;

import com.pcloud.book.applet.entity.AppletBookFeedback;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 小程序书刊资源意见反馈记录表(AppletBookFeedback)表数据库访问层
 *
 * @author guiq
 * @since 2021-02-20 17:13:22
 */
@Mapper
@Component
public interface AppletBookFeedbackMapper {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletBookFeedback queryById(Long id);

    /**
     * 查询指定行数据
     *
     * @param offset 查询起始位置
     * @param limit  查询条数
     * @return 对象列表
     */
    List<AppletBookFeedback> queryAllByLimit(@Param("offset") int offset, @Param("limit") int limit);


    /**
     * 通过实体作为筛选条件查询
     *
     * @param appletBookFeedback 实例对象
     * @return 对象列表
     */
    List<AppletBookFeedback> queryAll(AppletBookFeedback appletBookFeedback);

    /**
     * 新增数据
     *
     * @param appletBookFeedback 实例对象
     * @return 影响行数
     */
    int insert(AppletBookFeedback appletBookFeedback);

    /**
     * 批量新增数据（MyBatis原生foreach方法）
     *
     * @param entities List<AppletBookFeedback> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<AppletBookFeedback> entities);

    /**
     * 批量新增或按主键更新数据（MyBatis原生foreach方法）
     *
     * @param entities List<AppletBookFeedback> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<AppletBookFeedback> entities);

    /**
     * 修改数据
     *
     * @param appletBookFeedback 实例对象
     * @return 影响行数
     */
    int update(AppletBookFeedback appletBookFeedback);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

}

