package com.pcloud.book.book.biz;

import java.util.List;

import com.pcloud.book.book.dto.BookFreezeDto;
import com.pcloud.book.book.entity.BookFreeze;
import com.pcloud.book.book.entity.ThawEarning;

/**
 * 图书冻结业务层接口
 * 
 * @author lili
 * @date 2018/1/18 18:16
 */
public interface BookFreezeBiz {
	/**
	 * 获取图书是否被冻结
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	Boolean isFreeze(Long bookId);

	/**
	 * 冻结收益
	 * 
	 * @param bookFreeze
	 *            图书冻结
	 */
	void create(BookFreeze bookFreeze);

	/**
	 * 获取冻结信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	BookFreezeDto getBaseById(Long bookId);

	/**
	 * 解冻收益
	 * 
	 * @param thawEarning
	 *            解冻收益
	 * @param partyId
	 *            解冻人标识
	 */
	void thaw(ThawEarning thawEarning, Long partyId);

	/**
	 * 该书刊当前和以后基金冻结信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	List<BookFreezeDto> getFreezeInfo(Long bookId);

	/**
	 * 批量获取书刊当前和以后基金冻结信息
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	List<BookFreezeDto> listFreezeInfo(List<Long> bookIds);

	BookFreezeDto getById(Long bookId);

	Boolean setBookFreeze(Long bookId);
}
