package com.pcloud.book.book.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.book.book.entity.BookAdviserErp;
import com.pcloud.book.book.dao.BookAdviserErpDao;
import com.pcloud.book.book.biz.BookAdviserErpBiz;
import com.pcloud.book.book.vo.request.UpdateBookRobotProcessDto;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.List;

/**
 * 书与编辑临时关联表，供ERP自动创建书刊时使用，由于没有adviserId，所以暂存(BookAdviserErp)表服务实现类
 *
 * @author makejava
 * @since 2020-08-26 15:41:12
 */
@Service("bookAdviserErpBiz")
public class BookAdviserErpBizImpl implements BookAdviserErpBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(BookAdviserErpBizImpl.class);

    @Autowired
    private BookAdviserErpDao bookAdviserErpDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public BookAdviserErp getById(Long bookAdviserErpId) {
        return bookAdviserErpDao.getById(bookAdviserErpId);
    }

    /**
     * 创建编辑管理书籍关系
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long create(BookAdviserErp bookAdviserErp) {
        LOGGER.info("创建编辑与书籍关联关系【START】bookAdviserErp=" + bookAdviserErp);
        checkParam(bookAdviserErp);
        try {
            // 默认是主编辑
            bookAdviserErp.setIsMainEditor(true);
            bookAdviserErpDao.insert(bookAdviserErp);
            return bookAdviserErp.getBookAdviserErpId();
//                BookGroupDTO dtoByBookId = bookGroupBiz.getDTOByBookId(bookAdviserErp.getBookId(), bookAdviserErp.getChannelId(), bookAdviserErp.getAdviserId());
//                if(dtoByBookId != null){
//                    bookGroupBiz.createBookGroupAppletUrl(dtoByBookId.getId(),bookAdviserErp.getBookId(),bookAdviserErp.getChannelId(), bookAdviserErp.getAdviserId());
//                }
        } catch (DataIntegrityViolationException e) {
            throw new BookBizException(BookBizException.DB_DML_FAIL, "该书刊已经被别的编辑添加过");
        } catch (Exception e) {
            LOGGER.error("【书籍-编辑】编辑设置书籍推广信息,<ERROR>.[bookAdviserErpDao.insert]" + e.getMessage(), e);
            throw new BookBizException(BookBizException.DB_DML_FAIL, "设置书刊推广信息失败");
        }
    }

    /**
     * 校验参数
     * @param bookAdviserErp
     */
    private void checkParam(BookAdviserErp bookAdviserErp) {
        if (bookAdviserErp.getBookId() == null) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请选择书刊");
        }
//        if (bookAdviserErp.getChannelId() == null) {
//            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请选择运营平台");
//        }
    }

    @Override
    @ParamLog("修改")
    public void update(BookAdviserErp bookAdviserErp) {
        if(bookAdviserErp == null || !NumberUtil.isNumber(bookAdviserErp.getBookAdviserErpId())){
            throw BizException.PARAM_IS_NULL;
        }
        bookAdviserErpDao.update(bookAdviserErp);
    }

    @Override
    public BookAdviserErp getByBookId(Long bookId) {
        return bookAdviserErpDao.getByBookId(bookId);
    }
}
