package com.pcloud.book.book.biz.impl;

import com.pcloud.book.book.dao.BookSerialNumberDao;
import com.pcloud.book.book.biz.BookSerialNumberBiz;
import com.pcloud.book.book.entity.BookSerialNumber;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * 序号自动生成表(BookSerialNumber)表服务实现类
 *
 * @author makejava
 * @since 2020-08-26 14:04:04
 */
@Service("bookSerialNumberBiz")
public class BookSerialNumberBizImpl implements BookSerialNumberBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(BookSerialNumberBizImpl.class);

    @Autowired
    private BookSerialNumberDao bookSerialNumberDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public BookSerialNumber getById(Long id) {
        return bookSerialNumberDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = bookSerialNumberDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)){
            return pageBeanNew;
        }
        // 加载其它数据
        
        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public void insert(BookSerialNumber bookSerialNumber) {
        bookSerialNumberDao.insert(bookSerialNumber);
    }

    @Override
    @ParamLog("修改")
    public void update(BookSerialNumber bookSerialNumber) {
        if(bookSerialNumber == null){
            throw BizException.PARAM_IS_NULL;
        }
        bookSerialNumberDao.update(bookSerialNumber);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        bookSerialNumberDao.deleteById(id);
    }

    @Override
    public BookSerialNumber getByIsbn(String isbn) {
        return bookSerialNumberDao.getByIsbn(isbn);
    }
}
