package com.pcloud.book.book.biz.impl;

import com.pcloud.book.book.biz.SearchRecordSaleBiz;
import com.pcloud.book.book.dao.SearchRecordSaleDao;
import com.pcloud.book.book.entity.SearchRecord;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 用户搜索记录(SearchRecordSale)表服务实现类
 *
 * @author makejava
 * @since 2020-10-12 16:24:03
 */
@Service("searchRecordSaleBiz")
public class SearchRecordSaleBizImpl implements SearchRecordSaleBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(SearchRecordSaleBizImpl.class);

    @Autowired
    private SearchRecordSaleDao searchRecordSaleDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public SearchRecord getById(Integer id) {
        return searchRecordSaleDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = searchRecordSaleDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public void insert(SearchRecord searchRecordSale) {
        searchRecordSaleDao.insert(searchRecordSale);

    }

    @Override
    @ParamLog("修改")
    public void update(SearchRecord searchRecordSale) {
        if (searchRecordSale == null || !NumberUtil.isNumber(searchRecordSale.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        searchRecordSaleDao.update(searchRecordSale);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Integer id) {
        searchRecordSaleDao.deleteById(id);
    }
}