/**
 * 
 */
package com.pcloud.book.book.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import com.pcloud.book.book.dao.BookAppDao;
import com.pcloud.book.book.dto.BookAppDto;
import com.pcloud.book.book.entity.BookApp;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * @描述：书籍应用数据访问层接口实现类
 * @作者：songx
 * @创建时间：2016年12月23日,下午3:57:10 @版本：1.0
 */
@Repository("bookAppDao")
public class BookAppDaoImpl extends BaseDaoImpl<BookApp> implements BookAppDao {

	/**
	 * 删除作品应用关联关系
	 */
	@Override
	public long deleteByBook(Long bookId) {
		return super.getSqlSession().delete(super.getStatement("deleteByBook"), bookId);
	}

	/**
	 * 批量删除应用关联关系
	 */
	@Override
	public long deleteByBooks(List<Long> bookIds) {
		return super.getSqlSession().delete(super.getStatement("deleteByBooks"), bookIds);
	}

	/**
	 * 获取单个书籍和应用关联关系
	 */
	@Override
	public List<BookAppDto> listBaseById(BookApp bookApp) {
		return super.getSqlSession().selectList(super.getStatement("listBaseById"), bookApp);
	}

	/**
	 * 获取书籍关联的应用
	 */
	@Override
	public List<BookAppDto> getListById(BookApp bookApp) {
		return super.getSqlSession().selectList(super.getStatement("getListById"), bookApp);
	}

	/**
	 * 根据书籍和渠道删除书籍应用关联信息
	 */
	@Override
	public Integer deleteByBookAndChannel(Map<String, Object> paramMap) {

		return super.getSqlSession().delete(super.getStatement("deleteByBookAndChannel"), paramMap);

	}

	/**
	 * 获取基本关联关系
	 */
	@Override
	public BookAppDto getByBookAppId(Long bookAppId) {
		return super.getSqlSession().selectOne(this.getStatement("getByBookAppId"), bookAppId);
	}

	/**
	 * 获取图书关联应用个数
	 */
	@Override
	public Integer getAppCount(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(super.getStatement("getAppCount"), paramMap);
	}

	/**
	 * 删除应用关联图书
	 */
	@Override
	public void deleteByAppId(Map<String, Object> paramMap) {
		super.getSqlSession().delete(super.getStatement("deleteByAppId"), paramMap);
	}

	/**
	 * 删除书籍和应用的关系
	 */
	@Override
	public void updateBookApp4Adviser(Map<String, Object> paramMap) {
		super.getSqlSession().update(super.getStatement("updateBookApp4Adviser"), paramMap);
	}
}
