package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.SearchRecordSaleDao;
import com.pcloud.book.book.dto.AdviserBookInfoDTO;
import com.pcloud.book.book.entity.SearchRecord;
import com.pcloud.book.book.vo.BookSearchTopVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 用户搜索记录(SearchRecordSale)表数据库访问层
 *
 * @author makejava
 * @since 2020-10-12 16:24:03
 */
@Repository("searchRecordSaleDaoImpl")
public class SearchRecordSaleDaoImpl extends BaseDaoImpl<SearchRecord> implements SearchRecordSaleDao {
    @Override
    public void deleteByWxId(String wxId) {
        super.getSqlSession().delete(super.getStatement("deleteByWxId"),wxId);
    }

    @Override
    public List<String> getRecent5WxIds(Long bookId) {
        return super.getSqlSession().selectList(super.getStatement("getRecent5WxIds"),bookId);
    }

    @Override
    public void updateUserDeleteByWxId(String wxId, Boolean userDelete) {
        Map<String,Object> map=new HashMap<>();
        map.put("wxId",wxId);
        map.put("userDelete",userDelete);
        super.getSqlSession().update(super.getStatement("updateUserDeleteByWxId"),map);
    }

    @Override
    public List<BookSearchTopVO> getBookSearchTop(Integer top) {
        Map<String,Object> map=new HashMap<>();
        map.put("top",top);
        return super.getSqlSession().selectList(super.getStatement("getBookSearchTop"),map);
    }

    @Override
    public void updateUserDeleteByWechatUserId(Long wechatUserId, Boolean userDelete) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("userDelete",userDelete);
        super.getSqlSession().update(super.getStatement("updateUserDeleteByWechatUserId"),map);
    }

    @Override
    public Integer getBookSearchCount(String keyword) {
        Map<String,Object> map=new HashMap<>();
        map.put("keyword",keyword);
        return super.getSqlSession().selectOne(super.getStatement("getBookSearchCount"),map);
    }

    @Override
    public List<AdviserBookInfoDTO> getBookSearchIds(String keyword, Integer currentPage, Integer numPerPage) {
        Map<String,Object> map=new HashMap<>();
        map.put("keyword",keyword);
        map.put("pageNum",currentPage*numPerPage);
        map.put("numPerPage",numPerPage);
        return super.getSqlSession().selectList(super.getStatement("getBookSearchIds"),map);
    }

    @Override
    public List<Long> getWechatUserIds(Long bookId) {
        Map<String,Object> map=new HashMap<>();
        map.put("bookId",bookId);
        return super.getSqlSession().selectList(super.getStatement("getWechatUserIds"),map);
    }
}