package com.pcloud.book.book.facade;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.biz.BookOtherBiz;
import com.pcloud.book.book.entity.BookOther;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * (BookOther)表控制层
 *
 * @author makejava
 * @since 2020-12-02 18:51:00
 */
@RestController("bookOtherFacade")
@RequestMapping("bookOther")
public class BookOtherFacade {

    @Autowired
    private BookOtherBiz bookOtherBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(bookOtherBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(bookOtherBiz.getList(currentPage, numPerPage));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@RequestHeader("token") String token, @RequestBody BookOther bookOther)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(bookOtherBiz.insert(bookOther));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token, @RequestBody BookOther bookOther) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        bookOtherBiz.update(bookOther);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        bookOtherBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("获取保底权益的书")
    @GetMapping("getOtherBook")
    public ResponseDto<?> getOtherBook() throws BizException, PermissionException {
        bookOtherBiz.getOtherBook();
        return new ResponseDto<>();
    }

}