/**
 *
 */
package com.pcloud.book.book.facade;

import com.pcloud.book.book.dto.BookTypeDto;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.codehaus.jackson.JsonParseException;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2017年1月3日,下午3:13:21 @版本：1.0
 */
@Api(description = "书籍类型管理外部服务")
public interface BookTypeFacade {

    /**
     * 获取书籍类型列表
     *
     * @param token
     * @return
     */
    @ApiOperation(value = "获取书籍类型列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header")})
    @RequestMapping(value = "list", method = RequestMethod.GET)
    public ResponseDto<List<BookTypeDto>> getList(@RequestHeader("token") String token)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 微信端获取书籍类型列表
     *
     * @param userInfo
     * @return
     */
    @ApiOperation(value = "微信端获取书籍类型列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header")})
    @RequestMapping(value = "list4Wechat", method = RequestMethod.GET)
    public ResponseDto<List<BookTypeDto>> getList4Wechat(@CookieValue("userInfo") String userInfo)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 图书和期刊占比
     *
     * @param token
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "图书和期刊占比", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header")})
    @RequestMapping(value = "getPercent4Type", method = RequestMethod.GET)
    public ResponseDto<List<BookTypeDto>> getPercent4Type(@RequestHeader("token") String token)
            throws BizException, PermissionException, JsonParseException;

}
