package com.pcloud.book.book.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.pcloud.book.book.biz.BookResourceBiz;
import com.pcloud.book.book.dto.BookResourceDto;
import com.pcloud.book.book.dto.RaysSceneCatalogDto;
import com.pcloud.book.book.service.BookResourceService;
import com.pcloud.book.group.biz.ResourcePageBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * 图书资源
 * 
 * @author:lili
 * @date 创建时间：2017年3月21日 上午11:36:50
 * @version 1.0
 * @return
 */
@RestController("bookResourceService")
@RequestMapping("bookResourceService")
public class BookResourceServiceImpl implements BookResourceService {

	@Autowired
	private BookResourceBiz bookResourceBiz;
	@Autowired
	private ResourcePageBiz resourcePageBiz;

	/**
	 * 获取图书关联资源
	 */
	@Override
	@RequestMapping(value = "/listBookResource", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<List<BookResourceDto>>> listBookResource(
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId,
			@RequestParam(value = "adviserId", required = false) Long adviserId) {
		return ResponseHandleUtil.toResponse(bookResourceBiz.listBaseById(bookId, adviserId, channelId));
	}

	/**
	 * 获取资源关联的图书
	 */
	@Override
	@RequestMapping(value = "/listByResourceId", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<List<Long>>> listByResourceId(@RequestParam("resourceId") Long resourceId) {
		return ResponseHandleUtil.toResponse(bookResourceBiz.listByResourceId(resourceId));
	}

	/**
	 * 获取h5页面配了这个资源的二维码集合
	 */
	@Override
	@RequestMapping(value = "/getSceneIdsByResourceId", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<List<Long>>> getSceneIdsByResourceId(@RequestParam("resourceId") Long resourceId) {
		return ResponseHandleUtil.toResponse(resourcePageBiz.getSceneIdsByResourceId(resourceId));
	}

	@Override
	@PostMapping(value = "/listRaysSceneCatalogDto")
	public ResponseEntity<ResponseDto<List<RaysSceneCatalogDto>>> listRaysSceneCatalogDto(@RequestBody List<Long> sceneIds) {
		if (CollUtil.isEmpty(sceneIds)) return ResponseHandleUtil.toResponse(new ArrayList<>());
		return ResponseHandleUtil.toResponse(resourcePageBiz.listRaysSceneCatalogDto(sceneIds));
	}
}
