package com.pcloud.book.clock.service.impl;

import com.alibaba.fastjson.JSON;
import com.pcloud.book.clock.biz.BookClockBiz;
import com.pcloud.book.clock.biz.BookClockKeywordBiz;
import com.pcloud.book.clock.dao.BookClockKeywordDao;
import com.pcloud.book.clock.dto.BookClockInfoDTO;
import com.pcloud.book.clock.dto.BookGroupClockKeywordDTO;
import com.pcloud.book.clock.service.BookClockInfoService;
import com.pcloud.book.keywords.biz.BookGuideBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.common.utils.string.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @Description
 * @Author hzk
 * @Date 2019/5/29 10:25
 **/
@RestController("bookClockInfoService")
@RequestMapping("bookClockInfoService")
public class BookClockInfoServiceImpl implements BookClockInfoService {

    private static final Logger LOGGER = LoggerFactory.getLogger(BookClockInfoServiceImpl.class);

    @Autowired
    private BookClockKeywordBiz bookClockKeywordBiz;
    @Autowired
    private BookClockBiz bookClockBiz;
    @Autowired
    private BookGuideBiz bookGuideBiz;

    /**
     * 获取微信群某一动作动作关键词
     * @param bookClockInfoId
     * @param operation
     * @return
     * @throws BizException
     */
    @Override
    @RequestMapping(value = "getBookClockKeyword4Clock", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BookGroupClockKeywordDTO>> getBookClockKeyword4Clock(@RequestParam(value = "bookClockInfoId",required = false) Long bookClockInfoId,
                                                                                           @RequestParam("operation") String operation) throws BizException {
        LOGGER.info("getBookClockKeyword4Clock,param->"+bookClockInfoId+",operation="+operation);
        if(null == bookClockInfoId || StringUtil.isEmpty(operation)){
            return null;
        }
        return ResponseHandleUtil.toResponse(bookClockKeywordBiz.getBookClockKeyword4Clock(bookClockInfoId,operation));
    }

    @Override
    @RequestMapping(value = "sendBookClockGroupMessage", method = RequestMethod.POST)
    public void sendBookClockGroupMessage(@RequestBody Map<String, Object> map) throws BizException {
        LOGGER.info("内部接口群发消息被调用"+map.toString());
        return;
//        bookClockBiz.sendBookClockGroupMessage(map);

    }

    /**
     * @description 处理关联应用的打卡的旧数据
     * @author 杨涛
     * @date 2019/5/10 10:28
     */
    @Override
    @RequestMapping(value = "/dealOldData4WeixinClock", method = RequestMethod.GET)
    public void dealOldData4WeixinClock() {
        bookClockBiz.dealOldData4WeixinClock();
    }

    @Override
    @RequestMapping(value = "/dealOldData4WeixinAtt", method = RequestMethod.GET)
    public void dealOldData4WeixinAtt() {
        bookClockBiz.dealOldData4WeixinAtt();
    }

}
