package com.pcloud.book.copyright.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author lily
 * @date 2018/12/4 19:21
 */
@ApiModel
@Data
public class BookExportRecordDTO extends BaseEntity {


    @ApiModelProperty("下载地址")
    private String downloadUrl;

    @ApiModelProperty("生成码数量")
    private Integer codeCount;

    @ApiModelProperty("导出格式")
    private Integer isHaveBarCode;

    @ApiModelProperty("导出格式中文")
    private String importType;

    @ApiModelProperty("最后修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastModifiedDate;

}
