package com.pcloud.book.copyright.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lily
 * @date 2018/12/3 11:14
 */
@Data
@ApiModel
public class BookAuthInfo extends BaseEntity {
    @ApiModelProperty("图书授权信息标识")
    private Long id;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("编码可使用次数")
    private Integer codeUseCount;

    @ApiModelProperty("购买链接地址")
    private String buyUrl;

    @ApiModelProperty("图书状态")
    private Integer bookStatus;

    @ApiModelProperty("位置描述")
    private String locationDesc;

    @ApiModelProperty("验证类型")
    private Integer checkType;

    @ApiModelProperty("创建人")
    private Long createdUser;

    @ApiModelProperty("创建时间")
    private Date createdDate;

    @ApiModelProperty("最后修改人")
    private Long lastModifiedUser;

    @ApiModelProperty("最后修改时间")
    private Date lastModifiedDate;

    @ApiModelProperty("最近开启时间")
    private Date openTime;

    @ApiModelProperty("最近关闭时间")
    private Date closeTime;

    @ApiModelProperty("是否是现代纸书")
    private Integer isPaperBook;

    @ApiModelProperty("是否是社群书")
    private Integer isGroupBook;

    @ApiModelProperty("授权后仍需付费")
    private Integer isAuthorizedPay;

    @ApiModelProperty("打开支付功能；0：关闭；1：开启；")
    private Integer openPay;
}
