package com.pcloud.book.cultivate.facade;

import io.swagger.annotations.Api;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api("养成")
@RestController("cultivateFacade")
@RequestMapping("cultivate")
public class CultivateFacade {

    /*@Autowired
    private CultivateBiz cultivateBiz;


    @ApiOperation("新增养成")
    @PostMapping("/createCultivate")
    public ResponseDto<?> createCultivate(
            @CookieValue(value = "userInfo") String  userInfo,
            @RequestBody CreateCultivateDTO createCultivateDTO
    ) throws BizException, PermissionException {
        Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(cultivateBiz.createCultivate(createCultivateDTO));
    }

    @ApiOperation("获取养成")
    @GetMapping("/getCultivate")
    public ResponseDto<?> getCultivate(
        @CookieValue(value = "userInfo") String  userInfo
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getCultivate(Cookie.getId(userInfo, Cookie._WECHAT_USER_ID)));
    }

    @ApiOperation("新增养成分类关联")
    @PostMapping("/createCultivateRobotClassify")
    public ResponseDto<?> createCultivateRobotClassify(
            @RequestBody @ApiParam("养成分类关联") CultivateRobotClassify cultivateRobotClassify
            ) throws BizException, PermissionException {
        cultivateBiz.createCultivateRobotClassify(cultivateRobotClassify);
        return new ResponseDto<>();
    }

    @ApiOperation("能量消耗")
    @PostMapping("/energyConsumption")
    public ResponseDto<?> getCultivate(
        @CookieValue(value = "userInfo") String  userInfo,
            @RequestBody @ApiParam("养成分类关联")EnergyConsumptionDTO energyConsumptionDTO
    ) throws BizException, PermissionException {
        Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        cultivateBiz.energyConsumption(energyConsumptionDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("银两兑换")
    @PostMapping("/fishBallConversion")
    public ResponseDto<?> fishBallConversion(
            @CookieValue(value = "userInfo") String  userInfo,
            @RequestBody @ApiParam("银两兑换") FishBallConversionDTO fishBallConversionDTO
    ) throws BizException, PermissionException {
        Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        cultivateBiz.fishBallConversion(fishBallConversionDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("新增技能使用记录")
    @PostMapping("/addUseSkillRecord")
    public ResponseDto<?> addUseSkillRecord(
            @CookieValue(value = "userInfo") String  userInfo,
            @RequestBody @ApiParam("技能使用") SkillUseDTO skillUseDTO
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        cultivateBiz.addUseSkillRecord(wechatUserId,skillUseDTO);
        return new ResponseDto<>();
    }


    @ApiOperation("银两摘取")
    @PostMapping("/fishBallPick")
    public ResponseDto<?> fishBallPick(
            @CookieValue(value = "userInfo") String  userInfo,
            @RequestBody @ApiParam("银两摘取") FishBallPickDTO fishBallPickDTO
    ) throws BizException, PermissionException {
        Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        cultivateBiz.fishBallPick(fishBallPickDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("待摘取银两数量获取")
    @GetMapping("/getFishBallNotPick")
    public ResponseDto<?> getFishBallNotPick(
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getFishBallNotPick(cultivateId));
    }

    @ApiOperation("获取动态记录列表")
    @GetMapping("/getCultivateRecordList")
    public ResponseDto<?> getCultivateRecordList(
            @CookieValue(value = "userInfo") String  userInfo,
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId, @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage
    ) throws BizException, PermissionException {
        if (currentPage == null || numPerPage == null || currentPage < 0 || numPerPage < 0) {
            throw BookBizException.PAGE_PARAM_DELETION;
        }
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(cultivateBiz.getCultivateRecordList(cultivateId,wechatUserId,currentPage,numPerPage));
    }

    @ApiOperation("获取陪伴天数")
    @GetMapping("/getLoginDays")
    public ResponseDto<?> getLoginDays(@CookieValue(value = "userInfo") String  userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(cultivateBiz.getLoginDays(wechatUserId));
    }

    @ApiOperation("获取排名")
    @GetMapping("/getRanking")
    public ResponseDto<?> getRanking(@CookieValue(value = "userInfo") String  userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(cultivateBiz.getRanking(wechatUserId));
    }

    @ApiOperation("分享")
    @GetMapping("shareMedal")
    public ResponseDto<?> shareMedal(@CookieValue(value = "userInfo") String  userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(cultivateBiz.shareMedal(wechatUserId));
    }

    @ApiOperation("获取剩余亮灯时间")
    @GetMapping("/getResidueLightTime")
    public ResponseDto<?> getResidueLightTime(
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getResidueLightTime(cultivateId));
    }

    @ApiOperation("小睿养成读者喜好书籍")
    @PostMapping("/createCultivateBookUser")
    public ResponseDto<?> createCultivateBookUser(
            @CookieValue(value = "userInfo") String  userInfo,
            @RequestBody CultivateBookUser cultivateBookUser
    ) throws BizException, PermissionException {
        Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(cultivateBiz.createCultivateBookUser(cultivateBookUser));
    }

    @ApiOperation("获取最后一次小睿养成读者喜好书籍")
    @GetMapping("/getLastCultivateBookUser")
    public ResponseDto<?> getLastCultivateBookUser(
            @RequestParam("wechatUserId") Long wechatUserId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getLastCultivateBookUser(wechatUserId));
    }

    @ApiOperation("获取搜索书籍记录列表")
    @GetMapping("/getBookSearchRecord")
    public ResponseDto<?> getBookSearchRecord(
            @CookieValue(value = "userInfo") String  userInfo,@RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(cultivateBiz.getBookSearchRecord(wechatUserId,currentPage,numPerPage));
    }

    @ApiOperation("获取好友列表")
    @GetMapping("/getFriendList")
    public ResponseDto<?> getFriendList(
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId
    ) throws BizException, PermissionException {
        if(!NumberUtil.isNumber(cultivateId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "cultivateId 不能为空");
        }
        return new ResponseDto<>(cultivateBiz.getFriendList(cultivateId));
    }

    @ApiOperation("能量赠送")
    @PostMapping("/giveEnergy")
    public ResponseDto<?> giveEnergy(
            @RequestBody @ApiParam("养成id") GiveEnergyDTO giveEnergyDTO
    ) throws BizException, PermissionException {
        cultivateBiz.giveEnergy(giveEnergyDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("占位之前判断是否要切换占座")
    @GetMapping("/beforeHoldSeat")
    public ResponseDto<?> beforeHoldSeat(
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.beforeHoldSeat(cultivateId));
    }

    @ApiOperation("占位")
    @PostMapping("/holdSeat")
    public ResponseDto<?> holdSeat(
            @RequestBody @ApiParam("占座") HoldSeatDTO holdSeatDTO
    ) throws BizException, PermissionException {
        cultivateBiz.holdSeat(holdSeatDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("踢人")
    @PostMapping("/kickPeople")
    public ResponseDto<?> kickPeople(
            @RequestBody @ApiParam("踢人") HoldSeatDTO holdSeatDTO
    ) throws BizException, PermissionException {
        cultivateBiz.kickPeople(holdSeatDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("退出")
    @PostMapping("/signOut")
    public ResponseDto<?> signOut(
            @RequestBody @ApiParam("退出") HoldSeatDTO holdSeatDTO
    ) throws BizException, PermissionException {
        Integer proFishBall = cultivateBiz.signOut(holdSeatDTO);
        return new ResponseDto<>(proFishBall);
    }

    @ApiOperation("找回")
    @GetMapping("/getBack")
    public ResponseDto<?> getBack(
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getBack(cultivateId));
    }

    @ApiOperation("占座两个好友")
    @GetMapping("/getHoldSeatFriend")
    public ResponseDto<?> getHoldSeatFriend(
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getHoldSeatFriend(cultivateId));
    }

    @ApiOperation("获取养成基本信息")
    @GetMapping("/getCultivateBaseInfo")
    public ResponseDto<?> getCultivateBaseInfo(
            @RequestParam("cultivateId") @ApiParam("养成id") Long cultivateId
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateBiz.getCultivateBaseInfo(cultivateId));
    }*/

}
