package com.pcloud.book.custom.check;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.custom.dto.CustomTimeControlDTO;
import com.pcloud.book.custom.entity.CustomTimeControlBook;
import com.pcloud.book.custom.entity.CustomTimeControlReply;
import com.pcloud.book.keywords.enums.ReplyTypeEnum;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.stereotype.Component;

import java.util.List;

@Component("定制参数校验")
public class CustomCheck {


    @ParamLog("新增技能参数校验")
    public void createCustomTimeControlCheck(CustomTimeControlDTO customTimeControlDTO) {
        if (customTimeControlDTO==null){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数为空！");
        }
        if (customTimeControlDTO.getTimeControlTaskId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"读书计划id不能为空！");
        }
        checkReply(customTimeControlDTO.getReplyList4Subscribe());
        checkReply(customTimeControlDTO.getReplyList4Unsubscribe());
        checkBook(customTimeControlDTO.getRelatedBooks());
    }

    private void checkBook(List<CustomTimeControlBook> relatedBooks) {
        if (ListUtils.isEmpty(relatedBooks)){
            return;
        }
        if (relatedBooks.size() > 10){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "关联书籍不能超过10本！");
        }
        for(CustomTimeControlBook customTimeControlBook : relatedBooks){
            if (null == customTimeControlBook.getBookId()){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "bookid不能为空！");
            }
            if (null == customTimeControlBook.getReadType()){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "阅读类型不能为空！");
            }
        }
    }


    private void checkReply(List<CustomTimeControlReply> list){
        if (ListUtils.isEmpty(list)){
            return;
        }
        if (list.size() > 3){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "回复条数不能超过3条！");
        }
        for (CustomTimeControlReply reply :list){
            if (reply==null){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"回复不能为空！");
            }
            if (null == reply.getSubType()){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "订阅回复类型不能为空！");
            }
            if (null == reply.getReplyType()){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "回复类型不能为空！");
            }
            Integer type = reply.getReplyType();
            if (ReplyTypeEnum.TEXT.value.equals(type) && StringUtil.isEmpty(reply.getContent())) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "内容不能为空！");
            }
            if (ReplyTypeEnum.IMAGE.value.equals(type) && StringUtil.isEmpty(reply.getPicUrl())) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "图片地址不能为空！");
            }
            if (ReplyTypeEnum.APP.value.equals(type) && (StringUtil.isEmpty(reply.getServeType()) || reply.getServeId() == null || StringUtil.isEmpty(reply.getLinkUrl()))) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "应用或作品id和类型、链接不能为空！");
            }
            if (ReplyTypeEnum.RESOURCE.value.equals(type) && reply.getResourceId() == null) {
                throw new BookBizException(BookBizException.PARAM_IS_ERROR, "资源id不能为空！");
            }
        }
    }

    @ParamLog("修改技能校验")
    public void updateCustomTimeControlCheck(CustomTimeControlDTO customTimeControlDTO) {
        if (customTimeControlDTO.getId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"id不能为空！");
        }
        createCustomTimeControlCheck(customTimeControlDTO);
    }
}
