package com.pcloud.book.custom.dao.impl;

import com.pcloud.book.custom.dao.CustomReadPlanPeriodDao;
import com.pcloud.book.custom.dto.PeriodCountAndReadPlanDTO;
import com.pcloud.book.custom.entity.CustomReadPlanPeriod;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("customReadPlanPeriodDao")
public class CustomReadPlanPeriodDaoImpl extends BaseDaoImpl<CustomReadPlanPeriod> implements CustomReadPlanPeriodDao {
    @Override
    public Integer batchInsert(List<CustomReadPlanPeriod> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void deleteByCustomReadPlanId(Long customReadPlanId) {
        super.getSqlSession().update(getStatement("deleteByCustomReadPlanId"), customReadPlanId);
    }

    @Override
    public List<CustomReadPlanPeriod> getListByCustomReadPlanId(Long customReadPlanId) {
        return super.getSqlSession().selectList(getStatement("getListByCustomReadPlanId"), customReadPlanId);
    }

    @Override
    public List<PeriodCountAndReadPlanDTO> getPeriodCountGroupByReadPlanId(List<Long> list) {
        return super.getSqlSession().selectList(getStatement("getPeriodCountGroupByReadPlanId"), list);
    }
}
