package com.pcloud.book.es.facade.impl;

import com.pcloud.book.es.biz.ESNewsBiz;
import com.pcloud.book.es.facade.ESNewsFacade;
import com.pcloud.book.push.entity.News;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/13 16:43
 **/
@RestController("esNewsFacade")
@RequestMapping("esNews")
public class ESNewsFacadeImpl implements ESNewsFacade {


    @Autowired
    private ESNewsBiz esNewsBiz;

    @ApiOperation("添加所有的新闻到es")
    @PostMapping("addAllNewsToES")
    @Override
    public ResponseDto<?> addAllNewsToES() throws BizException {
        esNewsBiz.addAllNewsToES();
        return new ResponseDto<>();
    }

    @ApiOperation("新增新闻")
    @PostMapping("addNews")
    @Override
    public ResponseDto<?> addNews(@RequestBody News news) throws BizException {
        esNewsBiz.addNews(news);
        return new ResponseDto<>();
    }
}
