package com.pcloud.book.group.biz;

import com.pcloud.book.group.dto.BookGroupAppDTO;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.keywords.entity.BookGuide;
import com.pcloud.book.keywords.entity.BookGuideReply;
import com.pcloud.book.keywords.entity.BookKeyword;
import com.pcloud.book.keywords.entity.SelfRobotKeyword;
import com.pcloud.book.push.entity.PushGroup;
import com.pcloud.book.push.entity.PushItem;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface BookGroupAppBiz {

    void addAppKeywordToBookGroupApp(List<BookKeyword> bookKeywords);

    void addBookGuideToBookGroupApp(BookGuide bookGuide, List<BookGuideReply> bookGuideReplies);

    void addPushToBookGroupApp(List<PushGroup> pushGroups, List<PushItem> pushItems);

    void addServeToBookGroupApp(List<BookGroupServe> bookGroupServes);

    PageBeanNew<BookGroupAppDTO> getBookGroupAppDTOSByBookGroupId(Long bookGroupId, Integer currentPage, Integer numPerPage);

    void exportBookGroupAppDTOSByBookGroupId(Long bookGroupId,String systemCode,Long partyId);

    void addOldBookGroupAppToNew();

    void addSelfKeywordToBookGroupApp(List<SelfRobotKeyword> selfRobotKeywords);
}
