package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.GroupQrcodeStyleDao;
import com.pcloud.book.group.entity.GroupQrcodeStyle;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

/**
 * 描述  :二维码样式
 *
 * @author 作者: lili
 * @version 1.0
 * @date 创建时间：2017年6月30日 上午11:44:22
 */
@Component("groupQrcodeStyleDao")
public class GroupQrcodeStyleDaoImpl extends BaseDaoImpl<GroupQrcodeStyle> implements GroupQrcodeStyleDao {

    /**
     * 二维码样式
     */
    @Override
    public void delQrcodeStyle(Long bookGroupId) {
        this.getSqlSession().delete(this.getStatement("delQrcodeStyle"), bookGroupId);
    }

    @Override
    public GroupQrcodeStyle getQrcodeStyleByBookGroupId(Long bookGroupId) {
       return this.getSqlSession().selectOne(this.getStatement("getQrcodeStyleByBookGroupId"), bookGroupId);
    }
}
