package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/11/14 14:45
 **/
public class BookGroupAppDTO implements Serializable {

    private static final long serialVersionUID = -4055200132048502158L;

    @ApiModelProperty("id主键")
    private Long id;

    @ApiModelProperty("作品或应用id")
    private Long serveId;

    @ApiModelProperty("应用或作品")
    private String serveType;

    @ApiModelProperty("类型来源（1欢迎语,2关键词,3群发,4配置资源）")
    private Integer originType;

    @ApiModelProperty("社群码id")
    private Long bookGroupId;

    @ApiModelProperty("分类id")
    private Long classifyId;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("应用或作品名称")
    private String serveName;

    @ApiModelProperty("应用或作品类型名称")
    private String typeName;

    @ApiModelProperty("应用或作品类型code")
    private String typeCode;

    @ApiModelProperty("应用或作品创建者id")
    private Long serveCreateUserId;

    @ApiModelProperty("应用或作品创建者名称")
    private String serveCreateUserName;

    @ApiModelProperty("协议价")
    private Double dealPrice;

    @ApiModelProperty("销售价")
    private Double retailPrice;

    @ApiModelProperty("点击人数")
    private Integer clickPeopleCount;

    @ApiModelProperty("点击次数")
    private Integer clickCount;

    @ApiModelProperty("平均浏览时长")
    private Integer avgBrowseTime;

    @ApiModelProperty("购买人数")
    private Integer buyPeopleCount;

    @ApiModelProperty("销售额")
    private Double saleAmount;

    @ApiModelProperty("是否是超级作者")
    private Boolean isSuper;

    @ApiModelProperty("场景名称")
    private String sceneName;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getServeId() {
        return serveId;
    }

    public void setServeId(Long serveId) {
        this.serveId = serveId;
    }

    public String getServeType() {
        return serveType;
    }

    public void setServeType(String serveType) {
        this.serveType = serveType;
    }

    public Integer getOriginType() {
        return originType;
    }

    public void setOriginType(Integer originType) {
        this.originType = originType;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getServeName() {
        return serveName;
    }

    public void setServeName(String serveName) {
        this.serveName = serveName;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public Long getServeCreateUserId() {
        return serveCreateUserId;
    }

    public void setServeCreateUserId(Long serveCreateUserId) {
        this.serveCreateUserId = serveCreateUserId;
    }

    public String getServeCreateUserName() {
        return serveCreateUserName;
    }

    public void setServeCreateUserName(String serveCreateUserName) {
        this.serveCreateUserName = serveCreateUserName;
    }

    public Double getDealPrice() {
        return dealPrice;
    }

    public void setDealPrice(Double dealPrice) {
        this.dealPrice = dealPrice;
    }

    public Double getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(Double retailPrice) {
        this.retailPrice = retailPrice;
    }

    public Integer getClickPeopleCount() {
        return clickPeopleCount;
    }

    public void setClickPeopleCount(Integer clickPeopleCount) {
        this.clickPeopleCount = clickPeopleCount;
    }

    public Integer getClickCount() {
        return clickCount;
    }

    public void setClickCount(Integer clickCount) {
        this.clickCount = clickCount;
    }

    public Integer getAvgBrowseTime() {
        return avgBrowseTime;
    }

    public void setAvgBrowseTime(Integer avgBrowseTime) {
        this.avgBrowseTime = avgBrowseTime;
    }

    public Integer getBuyPeopleCount() {
        return buyPeopleCount;
    }

    public void setBuyPeopleCount(Integer buyPeopleCount) {
        this.buyPeopleCount = buyPeopleCount;
    }

    public Double getSaleAmount() {
        return saleAmount;
    }

    public void setSaleAmount(Double saleAmount) {
        this.saleAmount = saleAmount;
    }

    public Boolean getIsSuper() {
        return isSuper;
    }

    public void setIsSuper(Boolean isSuper) {
        this.isSuper = isSuper;
    }

    public String getSceneName() {
        return sceneName;
    }

    public void setSceneName(String sceneName) {
        this.sceneName = sceneName;
    }

    @Override
    public String toString() {
        return "BookGroupAppDTO{" +
                "id=" + id +
                ", serveId=" + serveId +
                ", serveType='" + serveType + '\'' +
                ", originType=" + originType +
                ", bookGroupId=" + bookGroupId +
                ", classifyId=" + classifyId +
                ", createUser=" + createUser +
                ", createTime=" + createTime +
                ", serveName='" + serveName + '\'' +
                ", typeName='" + typeName + '\'' +
                ", typeCode='" + typeCode + '\'' +
                ", serveCreateUserId=" + serveCreateUserId +
                ", serveCreateUserName='" + serveCreateUserName + '\'' +
                ", dealPrice=" + dealPrice +
                ", retailPrice=" + retailPrice +
                ", clickPeopleCount=" + clickPeopleCount +
                ", clickCount=" + clickCount +
                ", avgBrowseTime=" + avgBrowseTime +
                ", buyPeopleCount=" + buyPeopleCount +
                ", saleAmount=" + saleAmount +
                ", isSuper=" + isSuper +
                ", sceneName='" + sceneName + '\'' +
                '}';
    }
}
