package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/23 18:17
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ClassifyLearningReportDto implements Serializable {

    private static final long serialVersionUID = -5175893581465763555L;


    @ApiModelProperty("分类标识")
    private Long classifyId;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("图书名称")
    private String bookName;

    @ApiModelProperty("群分类")
    private String classify;

    @ApiModelProperty("社群码标识")
    private String bookGroupId;

    @ApiModelProperty("群二维码名称")
    private String groupQrcodeName;

    @ApiModelProperty("专业标签ID")
    private Long proLabelId;

    @ApiModelProperty("深度标签ID")
    private Long depLabelId;

    @ApiModelProperty("目的标签ID")
    private Long purLabelId;

    @ApiModelProperty("专业标签名称")
    private String proLabelName;

    @ApiModelProperty("深度标签名称")
    private String depLabelName;

    @ApiModelProperty("目的标签名称")
    private String purLabelName;

    @ApiModelProperty("学习报告触发次数")
    private Integer learningReportTouchCount;

    @ApiModelProperty("学习报告浏览次数")
    private Integer learningReportBrowseCount;

    @ApiModelProperty("是否开启学习报告")
    private Boolean hasOpenLearningReport;

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public String getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(String bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public Long getProLabelId() {
        return proLabelId;
    }

    public void setProLabelId(Long proLabelId) {
        this.proLabelId = proLabelId;
    }

    public Long getDepLabelId() {
        return depLabelId;
    }

    public void setDepLabelId(Long depLabelId) {
        this.depLabelId = depLabelId;
    }

    public Long getPurLabelId() {
        return purLabelId;
    }

    public void setPurLabelId(Long purLabelId) {
        this.purLabelId = purLabelId;
    }

    public String getProLabelName() {
        return proLabelName;
    }

    public void setProLabelName(String proLabelName) {
        this.proLabelName = proLabelName;
    }

    public String getDepLabelName() {
        return depLabelName;
    }

    public void setDepLabelName(String depLabelName) {
        this.depLabelName = depLabelName;
    }

    public String getPurLabelName() {
        return purLabelName;
    }

    public void setPurLabelName(String purLabelName) {
        this.purLabelName = purLabelName;
    }

    public Integer getLearningReportTouchCount() {
        return learningReportTouchCount;
    }

    public void setLearningReportTouchCount(Integer learningReportTouchCount) {
        this.learningReportTouchCount = learningReportTouchCount;
    }

    public Integer getLearningReportBrowseCount() {
        return learningReportBrowseCount;
    }

    public void setLearningReportBrowseCount(Integer learningReportBrowseCount) {
        this.learningReportBrowseCount = learningReportBrowseCount;
    }

    public Boolean getHasOpenLearningReport() {
        return hasOpenLearningReport;
    }

    public void setHasOpenLearningReport(Boolean hasOpenLearningReport) {
        this.hasOpenLearningReport = hasOpenLearningReport;
    }

    @Override
    public String toString() {
        return "ClassifyLearningReportDto{" +
                "classifyId=" + classifyId +
                ", bookId=" + bookId +
                ", bookName='" + bookName + '\'' +
                ", classify='" + classify + '\'' +
                ", bookGroupId='" + bookGroupId + '\'' +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", proLabelId=" + proLabelId +
                ", depLabelId=" + depLabelId +
                ", purLabelId=" + purLabelId +
                ", proLabelName='" + proLabelName + '\'' +
                ", depLabelName='" + depLabelName + '\'' +
                ", purLabelName='" + purLabelName + '\'' +
                ", learningReportTouchCount=" + learningReportTouchCount +
                ", learningReportBrowseCount=" + learningReportBrowseCount +
                ", hasOpenLearningReport=" + hasOpenLearningReport +
                '}';
    }
}
