package com.pcloud.book.group.scheduled;

import com.alibaba.fastjson.JSONObject;
import com.pcloud.book.group.biz.BookGroupBiz;
import com.pcloud.book.group.dto.HotAppDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;

@Slf4j
@Component
public class HotAppScheduled {

    @Autowired
    private BookGroupBiz bookGroupBiz;

    /**
     * 每天凌晨1点更新热门应用数据
     */
    @Scheduled(cron = "0 0 1 * * ?")
    public void intiHotApp() {
        List<HotAppDTO> hotAppDTOS = bookGroupBiz.listHotApp();
        log.info("每天凌晨1点更新热门应用数据 hotAppDTOS:{}", JSONObject.toJSONString(hotAppDTOS));
    }

}
